/*
 * Decompiled with CFR 0.152.
 */
package mikera.util;

public final class Maths {
    public static final float ROOT_TWO = (float)Math.sqrt(2.0);
    public static final float ROOT_THREE = (float)Math.sqrt(3.0);
    public static final float E = (float)Math.exp(1.0);
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float TAU = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    private static final double EPSILON = 1.0E-5;

    public static float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static float fastInverseSqrt(float x) {
        float xhalf = 0.5f * x;
        int i = Float.floatToRawIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - xhalf * x * x;
        return x;
    }

    public static float alternateSqrt(float x) {
        if (x < 0.0f) {
            return 0.0f;
        }
        float r = Maths.approxSqrt(x);
        r -= 0.5f * (r * r - x) / r;
        r -= 0.5f * (r * r - x) / r;
        return r;
    }

    public static float approxSqrt(float x) {
        int i = Float.floatToRawIntBits(x);
        i = i + 1065353216 >>> 1;
        return Float.intBitsToFloat(i);
    }

    public static int clampToInteger(double value, int min, int max) {
        int v = (int)value;
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int clampToInteger(float value, int min, int max) {
        int v = (int)value;
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int middle(int a, int b, int c) {
        if (a < b) {
            if (b < c) {
                return b;
            }
            return a < c ? c : a;
        }
        if (a < c) {
            return a;
        }
        return b < c ? c : b;
    }

    public static float middle(float a, float b, float c) {
        if (a < b) {
            if (b < c) {
                return b;
            }
            return a < c ? c : a;
        }
        if (a < c) {
            return a;
        }
        return b < c ? c : b;
    }

    public static int sign(double a) {
        if (a == 0.0) {
            return 0;
        }
        return a > 0.0 ? 1 : -1;
    }

    public static int sign(float a) {
        if (a == 0.0f) {
            return 0;
        }
        return a > 0.0f ? 1 : -1;
    }

    public static final int sign(int a) {
        return a == 0 ? 0 : (a > 0 ? 1 : -1);
    }

    public static final int sign2(int a) {
        return (a >> 31) + (a > 0 ? 1 : 0);
    }

    public static int sign2fast(int a) {
        return 1 + (a >> 31) + (a - 1 >> 31);
    }

    public static int sign(long a) {
        if (a == 0L) {
            return 0;
        }
        return a > 0L ? 1 : -1;
    }

    public static float fmod(float n, float d) {
        float x = n / d;
        return n - (float)Maths.floor(x) * d;
    }

    public static int mod(int number, int divisor) {
        int r = number % divisor;
        if (r < 0) {
            r += divisor;
        }
        return r;
    }

    public static long quantize(long increase, long boundary, long base) {
        return (base + increase) / boundary - base / boundary;
    }

    public static double min(double a, double b, double c) {
        double result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static double max(double a, double b, double c) {
        double result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static float min(float a, float b, float c) {
        float result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static float max(float a, float b, float c) {
        float result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static final float min(float a, float b, float c, float d) {
        float result = a;
        if (result > b) {
            result = b;
        }
        if (result > c) {
            result = c;
        }
        if (result > d) {
            result = d;
        }
        return result;
    }

    public static final float max(float a, float b, float c, float d) {
        float result = a;
        if (result < b) {
            result = b;
        }
        if (result < c) {
            result = c;
        }
        if (result < d) {
            result = d;
        }
        return result;
    }

    public static int abs(int a) {
        return (a ^ a >> 31) - (a >> 31);
    }

    public static int abs2(int a) {
        int mask = a >> 31;
        return (a ^ mask) - mask;
    }

    public static int abs3(int a) {
        if (a < 0) {
            return -a;
        }
        return a;
    }

    public static float abs(float a) {
        if (a < 0.0f) {
            return -a;
        }
        return a;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static int min2(int a, int b) {
        return a ^ (a ^ b) & b - a >> 31;
    }

    public static int max2(int a, int b) {
        return a ^ (a ^ b) & a - b >> 31;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static int min(int a, int b, int c) {
        int result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static int max(int a, int b, int c) {
        int result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static float sigmoid(float a) {
        double ea = Math.exp(-a);
        float df = (float)(1.0 / (1.0 + ea));
        if (Float.isNaN(df)) {
            return a > 0.0f ? 1.0f : 0.0f;
        }
        return df;
    }

    public static double sigmoid(double a) {
        double ea = Math.exp(-a);
        double df = 1.0 / (1.0 + ea);
        if (Double.isNaN(df)) {
            return a > 0.0 ? 1.0 : 0.0;
        }
        return df;
    }

    public static float tanh(float a) {
        double ex = Math.exp(2.0f * a);
        float df = (float)((ex - 1.0) / (ex + 1.0));
        if (Float.isNaN(df)) {
            return a > 0.0f ? 1.0f : -1.0f;
        }
        return df;
    }

    public static double tanh(double a) {
        double ex = Math.exp(2.0 * a);
        double df = (ex - 1.0) / (ex + 1.0);
        if (Double.isNaN(df)) {
            return a > 0.0 ? 1.0 : -1.0;
        }
        return df;
    }

    public static double tanhScaled(double a) {
        return 1.7159 * Maths.tanh(0.6666666666666666 * a);
    }

    public static double tanhScaledDerivative(double a) {
        double ta = Maths.tanh(0.6666666666666666 * a);
        return 1.1439333333333332 * (ta * (1.0 - ta));
    }

    public static float inverseSigmoid(float a) {
        if (a >= 1.0f) {
            return 800.0f;
        }
        if (a <= 0.0f) {
            return -800.0f;
        }
        double ea = (double)a / (1.0 - (double)a);
        return (float)Math.log(ea);
    }

    public static float sigmoidDerivative(float a) {
        float sa = Maths.sigmoid(a);
        return sa * (1.0f - sa);
    }

    public static float tanhDerivative(float a) {
        float sa = Maths.tanh(a);
        return 1.0f - sa * sa;
    }

    public static float sin(double a) {
        return (float)Math.sin(a %= 6.2831854820251465);
    }

    public static float cos(double a) {
        return (float)Math.cos(a %= 6.2831854820251465);
    }

    public static float sin(float a) {
        return (float)Math.sin(a %= (float)Math.PI * 2);
    }

    public static float cos(float a) {
        return (float)Math.cos(a %= (float)Math.PI * 2);
    }

    public static int floor(float a) {
        if (a >= 0.0f) {
            return (int)a;
        }
        int x = (int)a;
        return a == (float)x ? x : x - 1;
    }

    public static float frac(float a) {
        return a - (float)Maths.floor(a);
    }

    public static double frac(double a) {
        return a - (double)Maths.floor(a);
    }

    public static int floor(double a) {
        if (a >= 0.0) {
            return (int)a;
        }
        int x = (int)a;
        return a == (double)x ? x : x - 1;
    }

    public static int square(byte b) {
        return b * b;
    }

    public static int square(int a) {
        return a * a;
    }

    public static float square(float a) {
        return a * a;
    }

    public static double square(double a) {
        return a * a;
    }

    public static float round(float f, int dp) {
        float factor = (float)Math.pow(10.0, -dp);
        return (float)Math.round(f / factor) * factor;
    }

    public static int roundUp(double d) {
        int i = (int)d;
        return (double)i == d ? i : i + 1;
    }

    public static int roundUp(Number d) {
        return Maths.roundUp(d.doubleValue());
    }

    public static int roundUp(float d) {
        int i = (int)d;
        return (float)i == d ? i : i + 1;
    }

    public static double softMaximum(double x, double y) {
        double max = Math.max(x, y);
        double min = Math.min(x, y);
        return max + Math.log(1.0 + Math.exp(max - min));
    }

    public static final float fastPower(float a, float b) {
        float x = Float.floatToRawIntBits(a);
        x *= 1.1920929E-7f;
        float y = (x -= 127.0f) - (float)((int)Math.floor(x));
        b *= x + (y - y * y) * 0.346607f;
        y = b - (float)((int)Math.floor(b));
        y = (y - y * y) * 0.33971f;
        return Float.intBitsToFloat((int)((b + 127.0f - y) * 8388608.0f));
    }

    public static final float smoothStep(float a, float b, float x) {
        if (x <= a) {
            return 0.0f;
        }
        if (x >= b) {
            return 1.0f;
        }
        float t = Maths.bound(0.0f, (x - a) / (b - a), 1.0f);
        return t * t * (3.0f - 2.0f * t);
    }

    public static final float lerp(float t, float a, float b) {
        return (1.0f - t) * a + t * b;
    }

    public static final float smoothFactor(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    public static final float bound(float min, float v, float max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static final double bound(double min, double v, double max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static final int bound(int min, int v, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static boolean notNearZero(double d) {
        return d < -1.0E-5 || d > 1.0E-5;
    }
}

