/*
 * Decompiled with CFR 0.152.
 */
package mikera.util;

public final class Maths {
    public static final double ROOT_TWO = (float)Math.sqrt(2.0);
    public static final double ROOT_THREE = (float)Math.sqrt(3.0);
    public static final double E = Math.E;
    public static final double PI = 3.1415927410125732;
    public static final double TWO_PI = 6.2831854820251465;
    public static final double TAU = 6.2831854820251465;
    public static final double HALF_PI = 1.5707963705062866;
    public static final double QUARTER_PI = 0.7853981852531433;
    private static final double EPSILON = 1.0E-5;

    public static float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static int clampToInteger(double value, int min, int max) {
        int v = (int)value;
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int clampToInteger(float value, int min, int max) {
        int v = (int)value;
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static final double lerp(double t, double a, double b) {
        return (1.0 - t) * a + t * b;
    }

    public static int middle(int a, int b, int c) {
        if (a < b) {
            if (b < c) {
                return b;
            }
            return a < c ? c : a;
        }
        if (a < c) {
            return a;
        }
        return b < c ? c : b;
    }

    public static float middle(float a, float b, float c) {
        if (a < b) {
            if (b < c) {
                return b;
            }
            return a < c ? c : a;
        }
        if (a < c) {
            return a;
        }
        return b < c ? c : b;
    }

    public static int sign(double a) {
        if (a == 0.0) {
            return 0;
        }
        return a > 0.0 ? 1 : -1;
    }

    public static int sign(float a) {
        if (a == 0.0f) {
            return 0;
        }
        return a > 0.0f ? 1 : -1;
    }

    public static final int sign(int a) {
        return a == 0 ? 0 : (a > 0 ? 1 : -1);
    }

    public static final int sign2(int a) {
        return (a >> 31) + (a > 0 ? 1 : 0);
    }

    public static int sign(long a) {
        if (a == 0L) {
            return 0;
        }
        return a > 0L ? 1 : -1;
    }

    public static int mod(int number, int divisor) {
        int r = number % divisor;
        if (r < 0) {
            r += divisor;
        }
        return r;
    }

    public static long quantize(long increase, long boundary, long base) {
        return (base + increase) / boundary - base / boundary;
    }

    public static double min(double a, double b, double c) {
        double result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static double max(double a, double b, double c) {
        double result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static float min(float a, float b, float c) {
        float result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static float max(float a, float b, float c) {
        float result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static final float min(float a, float b, float c, float d) {
        float result = a;
        if (result > b) {
            result = b;
        }
        if (result > c) {
            result = c;
        }
        if (result > d) {
            result = d;
        }
        return result;
    }

    public static final float max(float a, float b, float c, float d) {
        float result = a;
        if (result < b) {
            result = b;
        }
        if (result < c) {
            result = c;
        }
        if (result < d) {
            result = d;
        }
        return result;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static int max(int a, int b) {
        return a > b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static int min(int a, int b, int c) {
        int result = a;
        if (b < result) {
            result = b;
        }
        if (c < result) {
            result = c;
        }
        return result;
    }

    public static int max(int a, int b, int c) {
        int result = a;
        if (b > result) {
            result = b;
        }
        if (c > result) {
            result = c;
        }
        return result;
    }

    public static float sigmoid(float a) {
        double ea = Math.exp(-a);
        float df = (float)(1.0 / (1.0 + ea));
        if (Float.isNaN(df)) {
            return a > 0.0f ? 1.0f : 0.0f;
        }
        return df;
    }

    public static double sigmoid(double a) {
        double ea = Math.exp(-a);
        double df = 1.0 / (1.0 + ea);
        if (Double.isNaN(df)) {
            return a > 0.0 ? 1.0 : 0.0;
        }
        return df;
    }

    public static double softplus(double a) {
        if (a > 100.0) {
            return a;
        }
        if (a < -100.0) {
            return 0.0;
        }
        return Math.log(1.0 + Math.exp(a));
    }

    public static float tanh(float a) {
        double ex = Math.exp(2.0f * a);
        float df = (float)((ex - 1.0) / (ex + 1.0));
        if (Float.isNaN(df)) {
            return a > 0.0f ? 1.0f : -1.0f;
        }
        return df;
    }

    public static double tanh(double a) {
        double ex = Math.exp(2.0 * a);
        double df = (ex - 1.0) / (ex + 1.0);
        if (Double.isNaN(df)) {
            return a > 0.0 ? 1.0 : -1.0;
        }
        return df;
    }

    public static double tanhScaled(double a) {
        return 1.7159 * Maths.tanh(0.6666666666666666 * a);
    }

    public static double tanhScaledDerivative(double a) {
        double ta = Maths.tanh(0.6666666666666666 * a);
        return 1.1439333333333332 * (ta * (1.0 - ta));
    }

    public static float inverseSigmoid(float a) {
        if (a >= 1.0f) {
            return 800.0f;
        }
        if (a <= 0.0f) {
            return -800.0f;
        }
        double ea = (double)a / (1.0 - (double)a);
        return (float)Math.log(ea);
    }

    public static float sigmoidDerivative(float a) {
        float sa = Maths.sigmoid(a);
        return sa * (1.0f - sa);
    }

    public static float tanhDerivative(float a) {
        float sa = Maths.tanh(a);
        return 1.0f - sa * sa;
    }

    public static float frac(float a) {
        return a - (float)Maths.roundDown(a);
    }

    public static double frac(double a) {
        return a - Math.floor(a);
    }

    public static int square(byte b) {
        return b * b;
    }

    public static int square(int x) {
        return x * x;
    }

    public static float square(float x) {
        return x * x;
    }

    public static double square(double x) {
        return x * x;
    }

    public static int roundUp(double d) {
        int i = (int)d;
        return (double)i == d ? i : i + 1;
    }

    public static int roundUp(Number d) {
        return Maths.roundUp(d.doubleValue());
    }

    public static int roundUp(float d) {
        int i = (int)d;
        return (float)i == d ? i : i + 1;
    }

    public static int roundDown(double a) {
        if (a >= 0.0) {
            return (int)a;
        }
        int x = (int)a;
        return a == (double)x ? x : x - 1;
    }

    public static int roundDown(float a) {
        if (a >= 0.0f) {
            return (int)a;
        }
        int x = (int)a;
        return a == (float)x ? x : x - 1;
    }

    public static double softMaximum(double x, double y) {
        double max = Math.max(x, y);
        double min = Math.min(x, y);
        return max + Math.log(1.0 + Math.exp(max - min));
    }

    public static final double bound(double v, double min, double max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static final float bound(float v, float min, float max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static final int bound(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int modPower32Bit(int x, int pow) {
        int result = 1;
        for (int n = pow; n > 0; n >>>= 1) {
            if ((n & 1) != 0) {
                result *= x;
            }
            x *= x;
        }
        return result;
    }

    public static boolean notNearZero(double d) {
        return d < -1.0E-5 || d > 1.0E-5;
    }

    public static double mod(double num, double div) {
        double result = num % div;
        if (result < 0.0) {
            result += div;
        }
        return result;
    }

    public static double triangleWave(double a) {
        return (a -= Math.floor(a)) < 0.5 ? a * 2.0 : 2.0 - a * 2.0;
    }
}

