/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import mikera.gui.ImageUtils;
import mikera.gui.JIcon;

public class Frames {
    private static final HashMap<String, JFrame> frames = new HashMap();

    public static JFrame createFrame(String title) {
        JFrame f = frames.get(title);
        if (f == null) {
            f = new JFrame(title);
            frames.put(title, f);
            f.setVisible(true);
            f.pack();
            f.setDefaultCloseOperation(2);
        } else {
            f.getContentPane().removeAll();
            if (!f.isVisible()) {
                f.setVisible(true);
            } else {
                f.validate();
            }
            f.repaint();
        }
        f.setDefaultCloseOperation(2);
        return f;
    }

    public static JFrame createImageFrame(final BufferedImage image, String title) {
        final JFrame f = Frames.createFrame(title);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menuBar.add(menu);
        JMenuItem jmi = new JMenuItem("Save As...");
        menu.add(jmi);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileDialog fileDialog = new FileDialog((Frame)f, "Save Image As...", 1);
                fileDialog.setFile("*.png");
                fileDialog.setVisible(true);
                String fileName = fileDialog.getFile();
                if (fileName != null) {
                    File outputFile = new File(fileDialog.getDirectory(), fileName);
                    try {
                        ImageIO.write((RenderedImage)image, "png", outputFile);
                        System.out.println("Saving: " + outputFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JIcon c = new JIcon(image);
        c.setMinimumSize(new Dimension(image.getWidth(null), image.getHeight(null)));
        f.setMinimumSize(new Dimension(image.getWidth(null) + 20, image.getHeight(null) + 100));
        f.add(c);
        f.setJMenuBar(menuBar);
        f.setDefaultCloseOperation(2);
        f.pack();
        return f;
    }

    public static JFrame display(BufferedImage image, String title) {
        return Frames.displayImage(image, title);
    }

    public static JFrame displayImage(BufferedImage image, String title) {
        JFrame f = Frames.createImageFrame(image, title);
        return f;
    }

    public static void showFrame(JFrame f) {
        if (!f.isVisible()) {
            f.setVisible(true);
        }
        f.pack();
    }

    public static JFrame display(JComponent component) {
        JFrame f = Frames.createFrame("View Popup");
        f.getContentPane().add(component);
        Frames.showFrame(f);
        return f;
    }

    public static JFrame display(JComponent component, String title) {
        JFrame f = Frames.createFrame(title);
        f.getContentPane().add(component);
        Frames.showFrame(f);
        return f;
    }

    public static void main(String[] args) {
        Frames.display(new JButton("Hello!"), "Test Frame");
        Frames.display(new JButton("Hello Two!"), "Test Frame");
        Frames.displayImage(ImageUtils.newImage(200, 200), "Test Image Frame");
    }
}

