/*
 * Decompiled with CFR 0.152.
 */
package mikera.ui.steampunk;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import mikera.gui.BufferedImageIcon;
import mikera.ui.steampunk.Images;
import mikera.ui.steampunk.SteamPunkGraphicsUtils;
import mikera.ui.steampunk.SteamPunkPainter;
import mikera.util.Resource;

public class SteamPunkStyle
extends SynthStyle {
    private static final int BASE_INSET = 6;
    public static Font FONT;
    public static Font LARGE_FONT;
    public static Font HUGE_FONT;
    public static Insets ZERO_INSETS;
    public static Insets NORMAL_INSETS;
    public static SynthPainter PAINTER;
    public static SynthGraphicsUtils UTILS;
    public static final Color GOLD_COLOUR;
    public static final Color COLOUR_GOLD_TEXT;
    public static final Color COLOUR_DISABLED_TEXT;

    @Override
    protected Color getColorForState(SynthContext context, ColorType type) {
        if (type == ColorType.FOREGROUND) {
            return Color.LIGHT_GRAY;
        }
        if (type == ColorType.BACKGROUND) {
            return Color.DARK_GRAY;
        }
        if (type == ColorType.FOCUS) {
            return Color.WHITE;
        }
        if (type == ColorType.TEXT_FOREGROUND) {
            return this.getForegroundColour(context);
        }
        if (type == ColorType.TEXT_BACKGROUND) {
            return Color.WHITE;
        }
        return Color.GREEN;
    }

    public Color getForegroundColour(SynthContext context) {
        Region region = context.getRegion();
        if (region == Region.LABEL || region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
            JComponent c = context.getComponent();
            if (!c.isEnabled()) {
                return COLOUR_DISABLED_TEXT;
            }
            return COLOUR_GOLD_TEXT;
        }
        return Color.BLACK;
    }

    @Override
    public SynthPainter getPainter(SynthContext context) {
        return PAINTER;
    }

    private static Insets setInsets(Insets dest, Insets src) {
        if (dest == null) {
            return new Insets(src.top, src.left, src.bottom, src.right);
        }
        dest.top = src.top;
        dest.left = src.left;
        dest.right = src.right;
        dest.bottom = src.bottom;
        return dest;
    }

    @Override
    public Insets getInsets(SynthContext context, Insets insets) {
        Region region = context.getRegion();
        if (region == Region.TABBED_PANE_TAB) {
            return SteamPunkStyle.setInsets(insets, NORMAL_INSETS);
        }
        return super.getInsets(context, insets);
    }

    @Override
    public boolean isOpaque(SynthContext context) {
        return false;
    }

    @Override
    protected Font getFontForState(SynthContext context) {
        return FONT;
    }

    @Override
    public void installDefaults(SynthContext context) {
        super.installDefaults(context);
        JComponent c = context.getComponent();
        c.setForeground(this.getColorForState(context, ColorType.TEXT_FOREGROUND));
        if (c instanceof JButton) {
            c.setBorder(new EmptyBorder(6, 6, 6, 6));
        }
        if (c instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)c;
            this.setBitsIcons(cb, 128, 0);
            cb.setVerticalAlignment(0);
            cb.setHorizontalAlignment(2);
            cb.setHorizontalTextPosition(11);
            cb.setVerticalTextPosition(1);
        } else if (c instanceof JRadioButton) {
            JRadioButton rb = (JRadioButton)c;
            this.setBitsIcons(rb, 192, 0);
            rb.setVerticalAlignment(0);
            rb.setHorizontalAlignment(2);
            rb.setHorizontalTextPosition(11);
            rb.setVerticalTextPosition(1);
        } else if (c instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)c;
            splitPane.setDividerSize(14);
        }
        c.setOpaque(false);
        if (c instanceof JTextArea) {
            JTextArea ta = (JTextArea)c;
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
        }
    }

    private void setBitsIcons(AbstractButton c, int x, int y) {
        c.setIcon((Icon)new BufferedImageIcon(Images.BITS_NORMAL, x + 32, y, 32, 32, 16, 16));
        c.setSelectedIcon((Icon)new BufferedImageIcon(Images.BITS_NORMAL, x, y, 32, 32, 16, 16));
        c.setRolloverIcon((Icon)new BufferedImageIcon(Images.BITS_HIGHLIGHT, x + 32, y, 32, 32, 16, 16));
        c.setRolloverSelectedIcon((Icon)new BufferedImageIcon(Images.BITS_HIGHLIGHT, x, y, 32, 32, 16, 16));
        c.setPressedIcon((Icon)new BufferedImageIcon(Images.BITS_PRESSED, x + 32, y, 32, 32, 16, 16));
        c.setDisabledIcon((Icon)new BufferedImageIcon(Images.BITS_NORMAL, x + 32, y + 32, 32, 32, 16, 16));
        c.setDisabledSelectedIcon((Icon)new BufferedImageIcon(Images.BITS_NORMAL, x, y + 32, 32, 32, 16, 16));
    }

    static {
        ZERO_INSETS = new Insets(0, 0, 0, 0);
        NORMAL_INSETS = new Insets(6, 6, 6, 6);
        PAINTER = new SteamPunkPainter();
        UTILS = new SteamPunkGraphicsUtils();
        COLOUR_GOLD_TEXT = GOLD_COLOUR = new Color(200, 180, 0);
        COLOUR_DISABLED_TEXT = new Color(128, 128, 128);
        try {
            FONT = Font.createFont(0, Resource.getResourceAsStream((String)"fonts/GenR102.TTF"));
            FONT = FONT.deriveFont(1, 15.0f);
            LARGE_FONT = FONT.deriveFont(1, 22.0f);
            HUGE_FONT = FONT.deriveFont(1, 40.0f);
        }
        catch (Throwable e) {
            FONT = null;
            e.printStackTrace();
        }
    }
}

