/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.Timer;

public class JConsole
extends JComponent
implements HierarchyListener {
    private static final long serialVersionUID = 3571518591759968333L;
    private static final Color DEFAULT_FOREGROUND = Color.LIGHT_GRAY;
    private static final Color DEFAULT_BACKGROUND = Color.BLACK;
    private static final Font DEFAULT_FONT = new Font("Courier New", 0, 20);
    private static final int DEFAULT_BLINKRATE = 200;
    private static final boolean DEFAULT_BLINK_ON = true;
    private int size;
    private int rows;
    private int columns;
    private Color[] background;
    private Color[] foreground;
    private Font[] font;
    private char[] text;
    private int fontWidth;
    private int fontHeight;
    private int fontYOffset;
    private boolean cursorVisible = false;
    private boolean cursorBlinkOn = true;
    private boolean cursorInverted = true;
    private int curPosition = 0;
    private Font mainFont = null;
    private Font currentFont = null;
    private Color curForeground = DEFAULT_FOREGROUND;
    private Color curBackground = DEFAULT_BACKGROUND;
    private Timer blinkTimer;

    public JConsole(int columns, int rows) {
        this.setMainFont(DEFAULT_FONT);
        this.setFont(this.mainFont);
        this.init(columns, rows);
        this.setCursorBlink(true);
    }

    private void setMainFont(Font font) {
        this.mainFont = font;
        FontRenderContext fontRenderContext = new FontRenderContext(this.mainFont.getTransform(), false, false);
        Rectangle2D charBounds = this.mainFont.getStringBounds("X", fontRenderContext);
        this.fontWidth = (int)charBounds.getWidth();
        this.fontHeight = (int)charBounds.getHeight();
        this.fontYOffset = -((int)charBounds.getMinY());
        this.repaint();
    }

    private void stopBlinking() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.cursorInverted = true;
        }
    }

    private void startBlinking() {
        this.getTimer().start();
    }

    public void setCursorBlink(boolean blink) {
        if (blink) {
            this.cursorBlinkOn = true;
            this.startBlinking();
        } else {
            this.cursorBlinkOn = false;
            this.stopBlinking();
        }
    }

    public void setBlinkDelay(int millis) {
        this.getTimer().setDelay(millis);
    }

    private Timer getTimer() {
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer(200, new TimerAction());
            this.blinkTimer.setRepeats(true);
            if (this.cursorBlinkOn) {
                this.startBlinking();
            }
        }
        return this.blinkTimer;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    public void setRows(int rows) {
        this.init(this.columns, rows);
    }

    @Override
    public void setFont(Font f) {
        this.currentFont = f;
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        this.init(columns, this.rows);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getFontWidth() {
        return this.fontWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void repaintRegion(int x, int y, int width, int height) {
        int fw = this.getFontWidth();
        int fh = this.getFontHeight();
        this.repaint(x * fw, y * fh, width * fw, height * fh);
    }

    protected void init(int columns, int rows) {
        this.size = rows * columns;
        this.rows = rows;
        this.columns = columns;
        this.text = new char[this.size];
        this.background = new Color[this.size];
        this.foreground = new Color[this.size];
        this.font = new Font[this.size];
        Arrays.fill(this.background, DEFAULT_BACKGROUND);
        Arrays.fill(this.foreground, DEFAULT_FOREGROUND);
        Arrays.fill(this.font, DEFAULT_FONT);
        Arrays.fill(this.text, ' ');
        this.setPreferredSize(new Dimension(columns * this.fontWidth, rows * this.fontHeight));
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Rectangle r = g.getClipBounds();
        int x1 = (int)(r.getMinX() / (double)this.fontWidth);
        int x2 = (int)(r.getMaxX() / (double)this.fontWidth) + 1;
        int y1 = (int)(r.getMinY() / (double)this.fontWidth);
        int y2 = (int)(r.getMaxY() / (double)this.fontWidth) + 1;
        int curX = this.getCursorX();
        int curY = this.getCursorY();
        for (int j = Math.max(0, y1); j < Math.min(y2, this.rows); ++j) {
            int offset = j * this.columns;
            int start = Math.max(x1, 0);
            int end = Math.min(x2, this.columns);
            while (start < end) {
                int i;
                Color nfg = this.foreground[offset + start];
                Color nbg = this.background[offset + start];
                Font nf = this.font[offset + start];
                if (j == curY && start == curX) {
                    if (this.cursorVisible && this.cursorBlinkOn && this.cursorInverted) {
                        Color t = nfg;
                        nfg = nbg;
                        nbg = t;
                    }
                } else {
                    for (i = start + 1; i < end && (j != curY || i != curX) && nfg == this.foreground[offset + i] && nbg == this.background[offset + i] && nf == this.font[offset + i]; ++i) {
                    }
                }
                g.setFont(nf);
                g.setBackground(nbg);
                g.clearRect(this.fontWidth * start, j * this.fontHeight, this.fontWidth * (i - start), this.fontHeight);
                g.setColor(nfg);
                g.drawChars(this.text, offset + start, i - start, start * this.fontWidth, j * this.fontHeight + this.fontYOffset);
                start = i;
            }
        }
    }

    public void setCursorPos(int x, int y) {
        if (x < 0 || x >= this.columns) {
            throw new Error("Invalid X cursor position: " + x);
        }
        if (y < 0 || y >= this.rows) {
            throw new Error("Invalid Y cursor position: " + y);
        }
        this.curPosition = y * this.columns + x;
    }

    public int getCursorX() {
        return this.curPosition % this.columns;
    }

    public int getCursorY() {
        return this.curPosition / this.columns;
    }

    @Override
    public void setForeground(Color c) {
        this.curForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        this.curBackground = c;
    }

    @Override
    public Color getForeground() {
        return this.curForeground;
    }

    @Override
    public Color getBackground() {
        return this.curBackground;
    }

    public void captureStdOut() {
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void println(String x) {
                JConsole.this.writeln(x);
            }
        };
        System.setOut(ps);
    }

    public void write(char c) {
        int pos = this.curPosition;
        this.curPosition = pos = this.writeChar(c, pos);
    }

    public void writeln(String line) {
        this.write(line);
        this.write('\n');
    }

    private int writeChar(char c, int pos) {
        switch (c) {
            case '\n': {
                pos = (pos + this.columns) / this.columns * this.columns;
                break;
            }
            default: {
                this.text[pos] = c;
                this.foreground[pos] = this.curForeground;
                this.background[pos] = this.curBackground;
                this.font[pos] = this.currentFont;
                ++pos;
            }
        }
        if (pos >= this.size) {
            pos = 0;
        }
        return pos;
    }

    public void write(String string, Color foreGround, Color backGround) {
        this.setForeground(foreGround);
        this.setBackground(backGround);
        this.write(string);
    }

    public void fillArea(char c, Color fg, Color bg, int x, int y, int w, int h) {
        for (int q = Math.max(0, y); q < Math.min(y + h, this.rows); ++q) {
            for (int p = Math.max(0, x); p < Math.min(x + w, this.columns); ++p) {
                int offset = p + q * this.columns;
                this.text[offset] = c;
                this.foreground[offset] = fg;
                this.background[offset] = bg;
            }
        }
    }

    public void write(String string) {
        int pos = this.curPosition;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            pos = this.writeChar(c, pos);
        }
        this.curPosition = pos;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            if (this.isShowing()) {
                this.startBlinking();
            } else {
                this.stopBlinking();
            }
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JConsole.this.cursorBlinkOn && JConsole.this.isShowing()) {
                JConsole.this.cursorInverted = !JConsole.this.cursorInverted;
                JConsole.this.repaintRegion(JConsole.this.getCursorX(), JConsole.this.getCursorY(), 1, 1);
            } else {
                JConsole.this.blinkTimer.stop();
                JConsole.this.cursorInverted = true;
            }
        }
    }
}

