/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.WrappedSubVector;

public abstract class AVector
implements Cloneable,
Comparable<AVector> {
    public abstract int length();

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public AVector subVector(int offset, int length) {
        return new WrappedSubVector(this, offset, length);
    }

    @Override
    public int compareTo(AVector a) {
        int len = this.length();
        if (len != a.length()) {
            throw new IllegalArgumentException("Vectors must be same length for comparison");
        }
        for (int i = 0; i < len; ++i) {
            double diff = this.get(i) - a.get(i);
            if (diff < 0.0) {
                return -1;
            }
            if (!(diff > 0.0)) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AVector)) {
            return false;
        }
        AVector v = (AVector)o;
        int len = this.length();
        if (len != v.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == v.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Tools.hashCode(this.get(i));
        }
        return hashCode;
    }

    public void copyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            data[i + offset] = this.get(i);
        }
    }

    public void fill(double value) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, value);
        }
    }

    public void multiply(double factor) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * factor);
        }
    }

    public double magnitudeSquared() {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.get(i);
            total += x * x;
        }
        return total;
    }

    public double dotProduct(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            total += this.get(i) * v.get(i);
        }
        return total;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public void normalise() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.multiply(1.0 / d);
        }
    }

    public AVector clone() {
        return new Vector(this);
    }

    public void add(AVector v) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + v.get(i);
            this.set(i, x);
        }
    }

    public void addMultiple(AVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            double x = this.get(i) + v.get(i) * factor;
            this.set(i, x);
        }
    }

    public void subtract(AVector v) {
        this.addMultiple(v, -1.0);
    }

    public void subtractMultiple(AVector v, double factor) {
        this.addMultiple(v, -factor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.get(0));
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.get(i));
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

