/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.ArrayVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;

public final class ArraySubVector
extends ArrayVector {
    private final double[] data;
    private final int offset;
    private final int length;

    public ArraySubVector(double[] values) {
        this.offset = 0;
        this.length = values.length;
        this.data = new double[this.length];
        System.arraycopy(values, 0, this.data, 0, this.length);
    }

    public ArraySubVector(int length) {
        this.length = length;
        this.offset = 0;
        this.data = new double[length];
    }

    public ArraySubVector(ArraySubVector source) {
        this.length = source.length;
        this.offset = 0;
        this.data = new double[this.length];
        System.arraycopy(source.data, source.offset, this.data, 0, this.length);
    }

    ArraySubVector(ArrayVector source, int offset, int length) {
        int len = source.length();
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Negative offset for Vector: " + offset);
        }
        if (offset + length > len) {
            throw new IndexOutOfBoundsException("Beyond bounds of parent vector with offset: " + offset + " and length: " + length);
        }
        this.length = length;
        this.offset = source.getArrayOffset() + offset;
        this.data = source.getArray();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.data[this.offset + i];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        this.data[this.offset + i] = value;
    }

    public void add(ArrayVector v) {
        int vlength = v.length();
        if (vlength != this.length) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i;
            this.data[n] = this.data[n] + vdata[voffset + i];
        }
    }

    public void addMultiple(ArrayVector v, double factor) {
        int vlength = v.length();
        if (vlength != this.length) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i;
            this.data[n] = this.data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public void fill(double value) {
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void multiply(double factor) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + this.offset;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length; ++i) {
            hashCode = 31 * hashCode + Tools.hashCode(this.data[this.offset + i]);
        }
        return hashCode;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public Vector clone() {
        return new Vector(this);
    }
}

