/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;

public class WrappedSubVector
extends AVector {
    private final AVector wrapped;
    private final int offset;
    private final int length;

    public WrappedSubVector(AVector source, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start Index: " + offset);
        }
        if (offset + length > source.length()) {
            throw new IndexOutOfBoundsException("End Index: " + (offset + length));
        }
        this.wrapped = source;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.wrapped.get(i + this.offset);
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        this.wrapped.set(i + this.offset, value);
    }

    @Override
    public WrappedSubVector subVector(int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Start Index: " + offset);
        }
        if (offset + length > this.length) {
            throw new IndexOutOfBoundsException("End Index: " + (offset + length));
        }
        return new WrappedSubVector(this.wrapped, this.offset + offset, length);
    }
}

