/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.Vector1;
import mikera.vectorz.Vector2;
import mikera.vectorz.Vector3;
import mikera.vectorz.Vector4;
import mikera.vectorz.impl.ZeroLengthVector;
import mikera.vectorz.impl.ZeroVector;

public class Vectorz {
    public static final double DEFAULT_TOLERANCE = 1.0E-5;
    private static final AVector[] ZERO_VECTORS = new AVector[]{ZeroLengthVector.INSTANCE, new ZeroVector(1), new ZeroVector(2), new ZeroVector(3), new ZeroVector(4)};

    public static AVector create(double ... data) {
        switch (data.length) {
            case 0: {
                return ZeroLengthVector.INSTANCE;
            }
            case 1: {
                return Vector1.of(data);
            }
            case 2: {
                return Vector2.of(data);
            }
            case 3: {
                return Vector3.of(data);
            }
            case 4: {
                return Vector4.of(data);
            }
        }
        return Vector.of(data);
    }

    public static AVector join(AVector first, AVector second) {
        return first.join(second);
    }

    public static AVector createZeroVector(int length) {
        return Vectorz.createLength(length);
    }

    public static AVector createLength(int length) {
        switch (length) {
            case 0: {
                return ZeroLengthVector.INSTANCE;
            }
            case 1: {
                return new Vector1();
            }
            case 2: {
                return new Vector2();
            }
            case 3: {
                return new Vector3();
            }
            case 4: {
                return new Vector4();
            }
        }
        return new Vector(length);
    }

    public static AVector createSameSize(AVector v) {
        return Vectorz.createLength(v.length());
    }

    public static AVector deepCopy(AVector vector) {
        if (!vector.isReference()) {
            return vector.clone();
        }
        AVector nv = Vectorz.createLength(vector.length());
        vector.copyTo(nv, 0);
        return nv;
    }

    public static void copy(AVector source, int srcOffset, AVector dest, int destOffset, int length) {
        source.copy(srcOffset, length, dest, destOffset);
    }

    public static AVector createUniformRandomVector(int dimensions) {
        AVector v = Vectorz.createLength(dimensions);
        for (int i = 0; i < dimensions; ++i) {
            v.set(i, Math.random());
        }
        return v;
    }

    public static AVector createMutableVector(AVector t) {
        AVector v = Vectorz.createLength(t.length());
        v.set(t);
        return v;
    }

    public static AVector immutableZeroVector(int dimensions) {
        if (dimensions >= ZERO_VECTORS.length) {
            return new ZeroVector(dimensions);
        }
        return ZERO_VECTORS[dimensions];
    }
}

