/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix33;
import mikera.transformz.AAffineTransform;
import mikera.transformz.ATransform;
import mikera.transformz.ATranslation;
import mikera.transformz.Transformz;
import mikera.transformz.Translation3;
import mikera.transformz.marker.ISpecialisedTransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;

public final class Affine34
extends AAffineTransform
implements ISpecialisedTransform {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;

    public Affine34() {
    }

    public Affine34(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
    }

    public Affine34(AMatrix matrix, ATranslation trans) {
        this(matrix, trans.getTranslationVector());
    }

    public Affine34(AMatrix m, AVector v) {
        assert (v.length() == 3);
        assert (m.inputDimensions() == 3);
        assert (m.outputDimensions() == 3);
        this.m00 = m.get(0, 0);
        this.m01 = m.get(0, 1);
        this.m02 = m.get(0, 2);
        this.m10 = m.get(1, 0);
        this.m11 = m.get(1, 1);
        this.m12 = m.get(1, 2);
        this.m20 = m.get(2, 0);
        this.m21 = m.get(2, 1);
        this.m22 = m.get(2, 2);
        this.m03 = v.get(0);
        this.m13 = v.get(1);
        this.m23 = v.get(2);
    }

    public Affine34(Matrix33 m, AVector v) {
        assert (v.length() == 3);
        assert (m.inputDimensions() == 3);
        assert (m.outputDimensions() == 3);
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m03 = v.get(0);
        this.m13 = v.get(1);
        this.m23 = v.get(2);
    }

    @Override
    public AMatrix getMatrixComponent() {
        return new Matrix33(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    @Override
    public ATranslation getTranslationComponent() {
        return Transformz.createTranslation(Vector3.of(this.m03, this.m13, this.m23));
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector3 && dest instanceof Vector3) {
            this.transform((Vector3)source, (Vector3)dest);
            return;
        }
        double x = source.get(0);
        double y = source.get(1);
        double z = source.get(2);
        dest.set(0, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
        dest.set(1, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
        dest.set(2, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
    }

    @Override
    public void transformInPlace(AVector dest) {
        if (dest instanceof Vector3) {
            this.transformInPlace((Vector3)dest);
            return;
        }
        double x = dest.get(0);
        double y = dest.get(1);
        double z = dest.get(2);
        dest.set(0, this.m00 * x + this.m01 * y + this.m02 * z + this.m03);
        dest.set(1, this.m10 * x + this.m11 * y + this.m12 * z + this.m13);
        dest.set(2, this.m20 * x + this.m21 * y + this.m22 * z + this.m23);
    }

    public void transform(Vector3 source, Vector3 dest) {
        Vector3 s = source;
        dest.x = this.m00 * s.x + this.m01 * s.y + this.m02 * s.z + this.m03;
        dest.y = this.m10 * s.x + this.m11 * s.y + this.m12 * s.z + this.m13;
        dest.z = this.m20 * s.x + this.m21 * s.y + this.m22 * s.z + this.m23;
    }

    public void transformInPlace(Vector3 dest) {
        Vector3 s = dest;
        double tx = this.m00 * s.x + this.m01 * s.y + this.m02 * s.z + this.m03;
        double ty = this.m10 * s.x + this.m11 * s.y + this.m12 * s.z + this.m13;
        double tz = this.m20 * s.x + this.m21 * s.y + this.m22 * s.z + this.m23;
        s.x = tx;
        s.y = ty;
        s.z = tz;
    }

    @Override
    public int inputDimensions() {
        return 3;
    }

    @Override
    public int outputDimensions() {
        return 3;
    }

    @Override
    public void composeWith(ATransform a) {
        if (a instanceof Affine34) {
            this.composeWith((Affine34)a);
            return;
        }
        if (a instanceof Matrix33) {
            this.composeWith((Matrix33)a);
            return;
        }
        if (a instanceof Translation3) {
            this.composeWith((Translation3)a);
            return;
        }
        super.composeWith(a);
    }

    public void composeWith(Affine34 a) {
        double t00 = this.m00 * a.m00 + this.m01 * a.m10 + this.m02 * a.m20;
        double t01 = this.m00 * a.m01 + this.m01 * a.m11 + this.m02 * a.m21;
        double t02 = this.m00 * a.m02 + this.m01 * a.m12 + this.m02 * a.m22;
        double t10 = this.m10 * a.m00 + this.m11 * a.m10 + this.m12 * a.m20;
        double t11 = this.m10 * a.m01 + this.m11 * a.m11 + this.m12 * a.m21;
        double t12 = this.m10 * a.m02 + this.m11 * a.m12 + this.m12 * a.m22;
        double t20 = this.m20 * a.m00 + this.m21 * a.m10 + this.m22 * a.m20;
        double t21 = this.m20 * a.m01 + this.m21 * a.m11 + this.m22 * a.m21;
        double t22 = this.m20 * a.m02 + this.m21 * a.m12 + this.m22 * a.m22;
        double t03 = this.m00 * a.m03 + this.m01 * a.m13 + this.m02 * a.m23 + this.m03;
        double t13 = this.m10 * a.m03 + this.m11 * a.m13 + this.m12 * a.m23 + this.m13;
        double t23 = this.m20 * a.m03 + this.m21 * a.m13 + this.m22 * a.m23 + this.m23;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m03 = t03;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m13 = t13;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
        this.m23 = t23;
    }

    public void composeWith(Matrix33 a) {
        double t00 = this.m00 * a.m00 + this.m01 * a.m10 + this.m02 * a.m20;
        double t01 = this.m00 * a.m01 + this.m01 * a.m11 + this.m02 * a.m21;
        double t02 = this.m00 * a.m02 + this.m01 * a.m12 + this.m02 * a.m22;
        double t10 = this.m10 * a.m00 + this.m11 * a.m10 + this.m12 * a.m20;
        double t11 = this.m10 * a.m01 + this.m11 * a.m11 + this.m12 * a.m21;
        double t12 = this.m10 * a.m02 + this.m11 * a.m12 + this.m12 * a.m22;
        double t20 = this.m20 * a.m00 + this.m21 * a.m10 + this.m22 * a.m20;
        double t21 = this.m20 * a.m01 + this.m21 * a.m11 + this.m22 * a.m21;
        double t22 = this.m20 * a.m02 + this.m21 * a.m12 + this.m22 * a.m22;
        this.m00 = t00;
        this.m01 = t01;
        this.m02 = t02;
        this.m10 = t10;
        this.m11 = t11;
        this.m12 = t12;
        this.m20 = t20;
        this.m21 = t21;
        this.m22 = t22;
    }

    public void composeWith(Translation3 a) {
        this.m03 += a.dx;
        this.m13 += a.dy;
        this.m23 += a.dz;
    }
}

