/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public abstract class AVectorMatrix
extends AMatrix {
    public abstract void appendRow(AVector var1);

    @Override
    public abstract AVector getRow(int var1);

    @Override
    public double get(int row, int column) {
        return this.getRow(row).get(column);
    }

    @Override
    public void set(int row, int column, double value) {
        this.getRow(row).set(column, value);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            dest.set(i, this.getRow(i).dotProduct(source));
        }
    }

    @Override
    public double calculateElement(int i, AVector inputVector) {
        AVector row = this.getRow(i);
        return row.dotProduct(inputVector);
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            this.getRow(i).applyOp(op);
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public double elementSum() {
        int rc = this.rowCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.getRow(i).elementSum();
        }
        return result;
    }

    @Override
    public AVectorMatrix clone() {
        AVectorMatrix avm = (AVectorMatrix)super.clone();
        return avm;
    }
}

