/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.ISparse;
import mikera.vectorz.AVector;
import mikera.vectorz.util.VectorzException;

public final class SingleElementVector
extends AVector
implements ISparse {
    private final int dimensions;
    private final int index;
    private double value;

    public SingleElementVector(int componentIndex, int dimensions) {
        this.dimensions = dimensions;
        this.index = componentIndex;
    }

    public SingleElementVector(int componentIndex, int dimensions, double value) {
        this.dimensions = dimensions;
        this.index = componentIndex;
        this.value = value;
    }

    @Override
    public int length() {
        return this.dimensions;
    }

    @Override
    public double magnitude() {
        return this.value;
    }

    @Override
    public double elementSum() {
        return this.value;
    }

    @Override
    public double magnitudeSquared() {
        return this.value * this.value;
    }

    @Override
    public double normalise() {
        double ret = this.value;
        if (this.value > 0.0) {
            this.value = 1.0;
        } else if (this.value < 0.0) {
            this.value = -1.0;
        }
        return ret;
    }

    @Override
    public boolean isFullyMutable() {
        return this.dimensions == 1;
    }

    @Override
    public void scale(double factor) {
        this.value *= factor;
    }

    @Override
    public double density() {
        return 1.0 / (double)this.length();
    }

    @Override
    public double get(int i) {
        assert (i >= 0 && i < this.dimensions);
        return i == this.index ? this.value : 0.0;
    }

    @Override
    public void set(int i, double value) {
        assert (i >= 0 && i < this.dimensions);
        if (i != this.index) {
            throw new VectorzException("SingleElementVector not mutable at position: " + i);
        }
        this.value = value;
    }

    @Override
    public SingleElementVector exactClone() {
        return new SingleElementVector(this.index, this.dimensions, this.value);
    }
}

