/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.ops;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.ops.ALinearOp;
import mikera.vectorz.ops.LinearOp;

public final class OffsetOp
extends ALinearOp {
    private final double constant;

    private OffsetOp(double constant) {
        this.constant = constant;
    }

    public static OffsetOp create(double offset) {
        return new OffsetOp(offset);
    }

    @Override
    public double apply(double x) {
        return x + this.constant;
    }

    @Override
    public double applyInverse(double y) {
        return y - this.constant;
    }

    @Override
    public void applyTo(AVector v) {
        v.add(this.constant);
    }

    @Override
    public void applyTo(double[] data) {
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] + this.constant;
        }
    }

    @Override
    public void applyTo(double[] data, int start, int length) {
        for (int i = 0; i < length; ++i) {
            int n = i + start;
            data[n] = data[n] + this.constant;
        }
    }

    @Override
    public double getFactor() {
        return 1.0;
    }

    @Override
    public double getConstant() {
        return this.constant;
    }

    @Override
    public double averageValue() {
        return this.constant;
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    @Override
    public double derivative(double x) {
        return 1.0;
    }

    @Override
    public double derivativeForOutput(double y) {
        return 1.0;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public OffsetOp getInverse() {
        return OffsetOp.create(-this.constant);
    }

    public Op compose(ALinearOp op) {
        return LinearOp.create(op.getFactor(), this.constant + op.getConstant());
    }

    @Override
    public Op compose(Op op) {
        if (op instanceof ALinearOp) {
            return this.compose((ALinearOp)op);
        }
        return super.compose(op);
    }
}

