/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.arrayz.AbstractArray;
import mikera.arrayz.INDArray;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ScalarVector;
import mikera.vectorz.util.VectorzException;

public abstract class AScalar
extends AbstractArray {
    private static final int[] SCALAR_SHAPE = new int[0];

    @Override
    public abstract double get();

    @Override
    public void set(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dimensionality() {
        return 0;
    }

    @Override
    public INDArray slice(int position) {
        throw new UnsupportedOperationException("Can't slice a scalar!");
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return this.isMutable();
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    public void add(AScalar s) {
        this.set(this.get() + s.get());
    }

    public void sub(AScalar s) {
        this.set(this.get() - s.get());
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 0);
        return this.get();
    }

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length != 0) {
            throw new VectorzException("" + indexes.length + "D set not supported on AScalar");
        }
        this.set(value);
    }

    @Override
    public int[] getShape() {
        return SCALAR_SHAPE;
    }

    @Override
    public long elementCount() {
        return 1L;
    }

    @Override
    public AVector asVector() {
        return new ScalarVector(this);
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyOp(IOp op) {
        this.set(op.apply(this.get()));
    }

    @Override
    public void applyOp(Op op) {
        this.set(op.apply(this.get()));
    }

    @Override
    public AScalar clone() {
        return (AScalar)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AScalar) {
            return this.equals((AScalar)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    @Override
    public boolean equals(INDArray o) {
        return o.dimensionality() == 0 && o.get(SCALAR_SHAPE) == this.get();
    }

    public boolean equals(AScalar o) {
        return this.get() == o.get();
    }

    @Override
    public int hashCode() {
        return 31 + Hash.hashCode((double)this.get());
    }

    @Override
    public abstract AScalar exactClone();
}

