/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.DoubleArrays;

public final class JoinedArrayVector
extends AVector {
    private static final long serialVersionUID = -8470277860344236392L;
    private final int length;
    private final int numArrays;
    private final double[][] data;
    private final int[] offsets;
    private final int[] pos;

    private JoinedArrayVector(int length, double[][] newData, int[] offsets, int[] pos) {
        this.length = length;
        this.numArrays = newData.length;
        this.offsets = offsets;
        this.pos = pos;
        this.data = newData;
    }

    public static final JoinedArrayVector create(AVector v) {
        int length = v.length();
        double[][] data = new double[][]{new double[length]};
        v.copyTo(data[0], 0);
        JoinedArrayVector jav = new JoinedArrayVector(length, data, new int[1], new int[]{0, length});
        return jav;
    }

    public static JoinedArrayVector wrap(ArrayVector v) {
        return new JoinedArrayVector(v.length(), new double[][]{v.getArray()}, new int[]{v.getArrayOffset()}, new int[]{0, v.length()});
    }

    private int findArrayNum(int index) {
        assert (index >= 0 && index < this.length);
        int i = 0;
        int j = this.numArrays - 1;
        while (i < j) {
            int m = i + j >> 1;
            int p = this.pos[m];
            if (index < p) {
                j = m;
                continue;
            }
            int p2 = this.pos[m + 1];
            if (index >= p2) {
                i = m + 1;
                continue;
            }
            return m;
        }
        return i;
    }

    private int subLength(int j) {
        return this.pos[j + 1] - this.pos[j];
    }

    private ArraySubVector subArrayVector(int j) {
        return ArraySubVector.wrap(this.data[j], this.offsets[j], this.subLength(j));
    }

    public List<ArrayVector> toSubArrays() {
        ArrayList<ArrayVector> al = new ArrayList<ArrayVector>();
        for (int i = 0; i < this.numArrays; ++i) {
            al.add(this.subArrayVector(i));
        }
        return al;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public double get(int i) {
        int ai = this.findArrayNum(i);
        return this.data[ai][i - this.pos[ai] + this.offsets[ai]];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        int ai = this.findArrayNum(i);
        this.data[ai][i - this.pos[ai] + this.offsets[ai]] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int ai = this.findArrayNum(i);
        double[] dArray = this.data[ai];
        int n = i - this.pos[ai] + this.offsets[ai];
        dArray[n] = dArray[n] + value;
    }

    @Override
    public void copyTo(AVector dest, int offset) {
        for (int j = 0; j < this.numArrays; ++j) {
            dest.set(this.pos[j] + offset, this.data[j], this.offsets[j], this.subLength(j));
        }
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        for (int j = 0; j < this.numArrays; ++j) {
            result += DoubleArrays.elementSum(this.data[j], this.offsets[j], this.subLength(j));
        }
        return result;
    }

    @Override
    public double dotProduct(AVector v) {
        if (v instanceof ArrayVector) {
            ArrayVector av = (ArrayVector)v;
            return this.dotProduct(av);
        }
        return super.dotProduct(v);
    }

    public double dotProduct(ArrayVector v) {
        double result = 0.0;
        double[] arr = v.getArray();
        int ao = v.getArrayOffset();
        for (int j = 0; j < this.numArrays; ++j) {
            result += DoubleArrays.dotProduct(this.data[j], this.offsets[j], arr, ao + this.pos[j], this.subLength(j));
        }
        return result;
    }

    @Override
    public void add(AVector a) {
        this.add(0, a, 0, this.length);
    }

    @Override
    public void add(int offset, AVector a) {
        this.add(offset, a, 0, a.length());
    }

    @Override
    public void add(int offset, AVector a, int aOffset, int length) {
        int alen = length;
        for (int j = 0; j < this.numArrays; ++j) {
            if (offset >= this.pos[j + 1]) continue;
            int segmentOffset = Math.max(0, offset - this.pos[j]);
            int len = Math.min(this.subLength(j) - segmentOffset, offset + alen - this.pos[j]);
            if (len <= 0) continue;
            a.addToArray(aOffset + this.pos[j] + segmentOffset - offset, this.data[j], this.offsets[j] + segmentOffset, len);
        }
    }

    @Override
    public void addProduct(AVector a, AVector b, double factor) {
        this.addProduct(a, 0, b, 0, factor);
    }

    @Override
    public void addMultiple(AVector a, double factor) {
        this.addMultiple(0, a, 0, this.length(), factor);
    }

    @Override
    public void addMultiple(int offset, AVector a, double factor) {
        this.addMultiple(offset, a, 0, a.length(), factor);
    }

    @Override
    public void addMultiple(int offset, AVector a, int aOffset, int length, double factor) {
        int alen = length;
        for (int j = 0; j < this.numArrays; ++j) {
            if (offset >= this.pos[j + 1]) continue;
            int segmentOffset = Math.max(0, offset - this.pos[j]);
            int len = Math.min(this.subLength(j) - segmentOffset, offset + alen - this.pos[j]);
            if (len <= 0) continue;
            a.addMultipleToArray(factor, aOffset + this.pos[j] + segmentOffset - offset, this.data[j], this.offsets[j] + segmentOffset, len);
        }
    }

    @Override
    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        for (int j = 0; j < this.numArrays; ++j) {
            a.addProductToArray(factor, aOffset + this.pos[j], b, bOffset + this.pos[j], this.data[j], this.offsets[j], this.subLength(j));
        }
    }

    @Override
    public void applyOp(Op op) {
        for (int j = 0; j < this.numArrays; ++j) {
            op.applyTo(this.data[j], this.offsets[j], this.subLength(j));
        }
    }

    @Override
    public void copyTo(double[] destArray, int offset) {
        for (int j = 0; j < this.numArrays; ++j) {
            System.arraycopy(this.data[j], this.offsets[j], destArray, offset + this.pos[j], this.subLength(j));
        }
    }

    @Override
    public void multiplyTo(double[] target, int offset) {
        for (int j = 0; j < this.numArrays; ++j) {
            DoubleArrays.arraymultiply(this.data[j], this.offsets[j], target, offset + this.pos[j], this.subLength(j));
        }
    }

    @Override
    public void divideTo(double[] target, int offset) {
        for (int j = 0; j < this.numArrays; ++j) {
            DoubleArrays.arraydivide(this.data[j], this.offsets[j], target, offset + this.pos[j], this.subLength(j));
        }
    }

    @Override
    public void fill(double value) {
        for (int j = 0; j < this.numArrays; ++j) {
            Arrays.fill(this.data[j], this.offsets[j], this.offsets[j] + this.subLength(j), value);
        }
    }

    @Override
    public void set(AVector v) {
        for (int j = 0; j < this.numArrays; ++j) {
            v.copyTo(this.pos[j], this.data[j], this.offsets[j], this.subLength(j));
        }
    }

    @Override
    public void multiply(double value) {
        for (int j = 0; j < this.numArrays; ++j) {
            DoubleArrays.multiply(this.data[j], this.offsets[j], this.subLength(j), value);
        }
    }

    @Override
    public JoinedArrayVector exactClone() {
        double[][] newData = new double[this.numArrays][];
        int[] zeroOffsets = new int[this.numArrays];
        for (int i = 0; i < this.numArrays; ++i) {
            int alen = this.subLength(i);
            double[] arr = new double[alen];
            newData[i] = arr;
            System.arraycopy(this.data[i], this.offsets[i], arr, 0, alen);
        }
        return new JoinedArrayVector(this.length, newData, zeroOffsets, this.pos);
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (length == 0) {
            return Vector0.INSTANCE;
        }
        int a = this.findArrayNum(start);
        int b = this.findArrayNum(start + length - 1);
        int n = b - a + 1;
        if (n == 1) {
            return ArraySubVector.wrap(this.data[a], start - this.pos[a], length);
        }
        double[][] newData = (double[][])Arrays.copyOfRange(this.data, a, b + 1);
        int[] offs = new int[n];
        offs[0] = this.offsets[a] + (start - this.pos[a]);
        for (int j = 1; j < n; ++j) {
            offs[j] = this.offsets[a + j];
        }
        int[] poses = new int[n + 1];
        poses[0] = 0;
        for (int j = 1; j < n; ++j) {
            poses[j] = this.pos[a + j] - start;
        }
        poses[n] = length;
        return new JoinedArrayVector(length, newData, offs, poses);
    }

    @Override
    public AVector join(AVector v) {
        if (v instanceof JoinedArrayVector) {
            return JoinedArrayVector.joinVectors(this, (JoinedArrayVector)v);
        }
        if (v instanceof ArrayVector) {
            return this.join((ArrayVector)v);
        }
        return super.join(v);
    }

    public JoinedArrayVector join(ArrayVector v) {
        int newLen = this.length + v.length();
        int[] newOffsets = new int[this.numArrays + 1];
        System.arraycopy(this.offsets, 0, newOffsets, 0, this.numArrays);
        newOffsets[this.numArrays] = v.getArrayOffset();
        int[] newPos = new int[this.numArrays + 2];
        System.arraycopy(this.pos, 0, newPos, 0, this.numArrays + 1);
        newPos[this.numArrays + 1] = newLen;
        double[][] newData = new double[this.numArrays + 1][];
        System.arraycopy(this.data, 0, newData, 0, this.numArrays);
        newData[this.numArrays] = v.getArray();
        return new JoinedArrayVector(newLen, newData, newOffsets, newPos);
    }

    public JoinedArrayVector join(JoinedArrayVector v) {
        return JoinedArrayVector.joinVectors(this, v);
    }

    public static JoinedArrayVector joinVectors(JoinedArrayVector a, JoinedArrayVector b) {
        int newLen = a.length + b.length();
        int[] newOffsets = new int[a.numArrays + b.numArrays];
        System.arraycopy(a.offsets, 0, newOffsets, 0, a.numArrays);
        System.arraycopy(b.offsets, 0, newOffsets, a.numArrays, b.numArrays);
        int[] newPos = new int[a.numArrays + b.numArrays + 1];
        System.arraycopy(a.pos, 0, newPos, 0, a.numArrays);
        System.arraycopy(b.pos, 0, newPos, a.numArrays, b.numArrays + 1);
        int i = a.numArrays;
        while (i < newPos.length) {
            int n = i++;
            newPos[n] = newPos[n] + a.length;
        }
        double[][] newData = new double[a.numArrays + b.numArrays][];
        System.arraycopy(a.data, 0, newData, 0, a.numArrays);
        System.arraycopy(b.data, 0, newData, a.numArrays, b.numArrays);
        return new JoinedArrayVector(newLen, newData, newOffsets, newPos);
    }

    public static AVector joinVectors(ArrayVector a, ArrayVector b) {
        int alen = a.length();
        int blen = b.length();
        return new JoinedArrayVector(alen + blen, new double[][]{a.getArray(), b.getArray()}, new int[]{a.getArrayOffset(), b.getArrayOffset()}, new int[]{0, alen, alen + blen});
    }
}

