/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.AbstractArray;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.SliceArray;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.randomz.Hash;
import mikera.vectorz.AScalar;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.IOp;
import mikera.vectorz.IVector;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.VectorIterator;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.DoubleScalar;
import mikera.vectorz.impl.JoinedVector;
import mikera.vectorz.impl.ListWrapper;
import mikera.vectorz.impl.VectorIndexScalar;
import mikera.vectorz.impl.WrappedSubVector;
import mikera.vectorz.util.VectorzException;

public abstract class AVector
extends AbstractArray<Double>
implements IVector,
Comparable<AVector>,
Serializable {
    @Override
    public abstract int length();

    @Override
    public abstract double get(int var1);

    @Override
    public abstract void set(int var1, double var2);

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length != 1) {
            throw new VectorzException("" + indexes.length + "D set not supported on AVector");
        }
        this.set(indexes[0], value);
    }

    @Override
    public int dimensionality() {
        return 1;
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 1);
        return this.get(indexes[0]);
    }

    @Override
    public AScalar slice(int position) {
        return new VectorIndexScalar(this, position);
    }

    @Override
    public int sliceCount() {
        return this.length();
    }

    public List<Double> getSlices() {
        ArrayList<Double> al = new ArrayList<Double>();
        int l = this.length();
        for (int i = 0; i < l; ++i) {
            al.add(this.get(i));
        }
        return al;
    }

    @Override
    public int[] getShape() {
        return new int[]{this.length()};
    }

    @Override
    public long elementCount() {
        return this.length();
    }

    public AVector subVector(int offset, int length) {
        return new WrappedSubVector(this, offset, length);
    }

    public AVector join(AVector second) {
        return JoinedVector.joinVectors(this, second);
    }

    @Override
    public int compareTo(AVector a) {
        int len = this.length();
        if (len != a.length()) {
            throw new IllegalArgumentException("Vectors must be same length for comparison");
        }
        for (int i = 0; i < len; ++i) {
            double diff = this.get(i) - a.get(i);
            if (diff < 0.0) {
                return -1;
            }
            if (!(diff > 0.0)) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AVector) {
            return this.equals((AVector)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    public boolean equals(AVector v) {
        int len = this.length();
        if (len != v.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == v.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(INDArray v) {
        if (v.dimensionality() != 1) {
            return false;
        }
        int len = this.length();
        if (len != v.getShape()[0]) {
            return false;
        }
        int[] ind = new int[1];
        for (int i = 0; i < len; ++i) {
            ind[0] = i;
            if (this.get(i) == v.get(ind)) continue;
            return false;
        }
        return true;
    }

    public List<Double> toList() {
        ArrayList<Double> al = new ArrayList<Double>();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            al.add(this.get(i));
        }
        return al;
    }

    public boolean epsilonEquals(AVector v) {
        return this.epsilonEquals(v, 1.0E-7);
    }

    public boolean epsilonEquals(AVector v, double tolerance) {
        if (this == v) {
            return true;
        }
        int len = this.length();
        if (len != v.length()) {
            throw new VectorzException("Mismatched vector sizes!");
        }
        for (int i = 0; i < len; ++i) {
            if (Tools.epsilonEquals(this.get(i), v.get(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode((double)this.get(i));
        }
        return hashCode;
    }

    public void copyTo(double[] data, int offset) {
        this.copyTo(0, data, offset, this.length());
    }

    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.get(i + offset);
        }
    }

    public double[] toArray() {
        double[] result = new double[this.length()];
        this.copyTo(result, 0);
        return result;
    }

    public void copyTo(AVector dest, int destOffset) {
        if (dest instanceof ArrayVector) {
            this.copyTo((ArrayVector)dest, destOffset);
            return;
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            dest.set(destOffset + i, this.get(i));
        }
    }

    public void copyTo(ArrayVector dest, int destOffset) {
        this.copyTo(dest.getArray(), dest.getArrayOffset() + destOffset);
    }

    public void copyTo(int offset, AVector dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, this.get(offset + i));
        }
    }

    public void fill(double value) {
        this.fillRange(0, this.length(), value);
    }

    public void fillRange(int offset, int length, double value) {
        for (int i = 0; i < length; ++i) {
            this.set(i + offset, value);
        }
    }

    public void clamp(double min, double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (v < min) {
                this.set(i, min);
                continue;
            }
            if (!(v > max)) continue;
            this.set(i, max);
        }
    }

    public void clampMax(double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (!(v > max)) continue;
            this.set(i, max);
        }
    }

    public void clampMin(double min) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.get(i);
            if (!(v < min)) continue;
            this.set(i, min);
        }
    }

    public void multiply(double factor) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * factor);
        }
    }

    public void multiply(AVector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * v.get(i));
        }
    }

    public void multiply(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * data[i + offset]);
        }
    }

    public void multiplyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] * this.get(i);
        }
    }

    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    public void divide(AVector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) / v.get(i));
        }
    }

    public void divide(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) / data[i + offset]);
        }
    }

    public void divideTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] / this.get(i);
        }
    }

    public void abs() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, Math.abs(this.get(i)));
        }
    }

    public void signum() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, Math.signum(this.get(i)));
        }
    }

    @Override
    public void square() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double x = this.get(i);
            this.set(i, x * x);
        }
    }

    @Override
    public void scale(double factor) {
        this.multiply(factor);
    }

    public void scale(AVector v) {
        this.multiply(v);
    }

    public double scaleToMagnitude(double targetMagnitude) {
        double oldMagnitude = this.magnitude();
        this.multiply(targetMagnitude / oldMagnitude);
        return oldMagnitude;
    }

    public void scaleAdd(double factor, AVector v) {
        this.multiply(factor);
        this.add(v);
    }

    public void interpolate(AVector v, double alpha) {
        this.multiply(1.0 - alpha);
        this.addMultiple(v, alpha);
    }

    public void interpolate(AVector a, AVector b, double alpha) {
        this.set(a);
        this.interpolate(b, alpha);
    }

    public double magnitudeSquared() {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.get(i);
            total += x * x;
        }
        return total;
    }

    public AMatrix outerProduct(AVector a) {
        int rc = this.length();
        int cc = a.length();
        Matrix m = Matrix.create(rc, cc);
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                m.data[di++] = this.get(i) * a.get(j);
            }
        }
        return m;
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        if (a instanceof AVector) {
            return this.outerProduct((AVector)a);
        }
        return super.outerProduct(a);
    }

    public AScalar innerProduct(AVector v) {
        return DoubleScalar.create(this.dotProduct(v));
    }

    public AVector innerProduct(AMatrix m) {
        int cc = m.columnCount();
        int rc = m.rowCount();
        if (rc != this.length()) {
            throw new VectorzException("Incompatible sizes for inner product: [" + this.length() + "] x [" + rc + "," + cc + "]");
        }
        AVector r = Vectorz.newVector(cc);
        for (int i = 0; i < cc; ++i) {
            double y = 0.0;
            for (int j = 0; j < rc; ++j) {
                y += this.get(j) * m.get(j, i);
            }
            r.set(i, y);
        }
        return r;
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AVector) {
            return DoubleScalar.create(this.dotProduct((AVector)a));
        }
        return super.innerProduct(a);
    }

    public double dotProduct(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            total += this.get(i) * v.get(i);
        }
        return total;
    }

    public double dotProduct(AVector v, Index ix) {
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        for (int i = 0; i < vl; ++i) {
            result += this.get(ix.get(i)) * v.get(i);
        }
        return result;
    }

    public void crossProduct(AVector a) {
        assert (this.length() == 3 && a.length() == 3);
        double x = this.get(0);
        double y = this.get(1);
        double z = this.get(2);
        double x2 = a.get(0);
        double y2 = a.get(1);
        double z2 = a.get(2);
        double tx = y * z2 - z * y2;
        double ty = z * x2 - x * z2;
        double tz = x * y2 - y * x2;
        this.set(0, tx);
        this.set(1, ty);
        this.set(2, tz);
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double distanceSquared(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.get(i) - v.get(i);
            total += d * d;
        }
        return total;
    }

    public double distance(AVector v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distanceL1(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.get(i) - v.get(i);
            total += Math.abs(d);
        }
        return total;
    }

    public double distanceLinf(AVector v) {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = Math.abs(this.get(i) - v.get(i));
            result = Math.max(result, d);
        }
        return result;
    }

    public double maxAbsElement() {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double comp = this.get(i);
            if (comp > result) {
                result = comp;
                continue;
            }
            if (!(-comp > result)) continue;
            result = -comp;
        }
        return result;
    }

    public double normaliseMaxAbsElement() {
        double scale = this.maxAbsElement();
        this.scale(1.0 / scale);
        return scale;
    }

    public double elementSum() {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.get(i);
        }
        return result;
    }

    public double angle(AVector v) {
        return Math.acos(this.dotProduct(v) / (v.magnitude() * this.magnitude()));
    }

    public double normalise() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.multiply(1.0 / d);
        }
        return d;
    }

    public void negate() {
        this.multiply(-1.0);
    }

    public void set(AVector src) {
        int len = this.length();
        if (src.length() != len) {
            throw new IllegalArgumentException("Source Vector of wrong size: " + src.length());
        }
        for (int i = 0; i < len; ++i) {
            this.set(i, src.get(i));
        }
    }

    @Override
    public void set(double a) {
        this.fill(a);
    }

    @Override
    public void set(INDArray a) {
        if (a instanceof AVector) {
            this.set((AVector)a);
            return;
        }
        if (a.dimensionality() == 1) {
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                this.set(i, a.get(i));
            }
        } else {
            throw new IllegalArgumentException("Cannot set vector using array of dimensonality: " + a.dimensionality());
        }
    }

    public void set(AVector src, int srcOffset) {
        int len = this.length();
        assert (len + srcOffset <= src.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, src.get(srcOffset + i));
        }
    }

    public void set(double ... values) {
        int len = this.length();
        if (values.length != len) {
            throw new VectorzException("Trying to set vectors with incorrect number of doubles: " + values.length);
        }
        for (int i = 0; i < len; ++i) {
            this.set(i, values[i]);
        }
    }

    public int countZeros() {
        int z = 0;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (this.get(i) != 0.0) continue;
            ++z;
        }
        return z;
    }

    @Override
    public AVector clone() {
        AVector nv = Vectorz.newVector(this.length());
        this.copyTo(nv, 0);
        return nv;
    }

    @Override
    public AVector asVector() {
        return this;
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        int ndims = dimensions.length;
        if (ndims == 1) {
            return this.clone();
        }
        if (ndims == 2) {
            return Matrixx.createFromVector(this, dimensions[0], dimensions[1]);
        }
        return Arrayz.createFromVector(this, dimensions);
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        return this.isMutable();
    }

    public void add(AVector v) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, v.get(i));
        }
    }

    @Override
    public void add(INDArray a) {
        if (a instanceof AVector) {
            this.add((AVector)a);
        } else if (a instanceof AScalar) {
            this.add(a.get());
        } else {
            super.add(a);
        }
    }

    @Override
    public void sub(INDArray a) {
        if (a instanceof AVector) {
            this.sub((AVector)a);
        } else if (a instanceof AScalar) {
            this.sub(a.get());
        } else {
            super.sub(a);
        }
    }

    public void add(AVector src, int srcOffset) {
        int length = this.length();
        assert (srcOffset >= 0);
        assert (srcOffset + length <= src.length());
        for (int i = 0; i < length; ++i) {
            this.addAt(i, src.get(srcOffset + i));
        }
    }

    public void add(int offset, AVector a) {
        this.add(offset, a, 0, a.length());
    }

    public void add(int offset, AVector a, int aOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.addAt(offset + i, a.get(i + aOffset));
        }
    }

    public void addProduct(AVector a, AVector b) {
        this.addProduct(a, b, 1.0);
    }

    public void addProduct(AVector a, AVector b, double factor) {
        int length = this.length();
        assert (a.length() == length && b.length() == length);
        for (int i = 0; i < length; ++i) {
            this.addAt(i, a.get(i) * b.get(i) * factor);
        }
    }

    public void addMultiple(AVector v, double factor) {
        if (v.length() != this.length()) {
            throw new RuntimeException("Source vector has different size!" + v.length());
        }
        this.addMultiple(v, 0, factor);
    }

    public void addMultiple(AVector v, int vOffset, double factor) {
        this.addMultiple(0, v, vOffset, this.length(), factor);
    }

    public void addMultiple(int offset, AVector v, int vOffset, int length, double factor) {
        assert (offset + length <= this.length());
        for (int i = 0; i < length; ++i) {
            this.addAt(i + offset, v.get(i + vOffset) * factor);
        }
    }

    public void addMultiple(int offset, AVector v, double factor) {
        this.addMultiple(offset, v, 0, v.length(), factor);
    }

    public void addWeighted(AVector v, double factor) {
        this.multiply(1.0 - factor);
        this.addMultiple(v, factor);
    }

    public void sub(AVector v) {
        this.addMultiple(v, -1.0);
    }

    public void sub(double d) {
        this.add(-d);
    }

    public boolean isZeroVector() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isUnitLengthVector() {
        double mag = this.magnitudeSquared();
        return Math.abs(mag - 1.0) < 1.0E-7;
    }

    public void projectToPlane(AVector normal, double distance) {
        assert (Tools.epsilonEquals(normal.magnitude(), 1.0));
        double d = this.dotProduct(normal);
        this.addMultiple(normal, distance - d);
    }

    public void subMultiple(AVector v, double factor) {
        this.addMultiple(v, -factor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.get(0));
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.get(i));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public List<Double> asList() {
        return new ListWrapper(this);
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator(this);
    }

    public void set(IVector vector) {
        int len = this.length();
        assert (len == vector.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void addMultiple(Vector source, Index sourceToDest, double factor) {
        if (sourceToDest.length() != source.length()) {
            throw new VectorzException("Index must match source vector");
        }
        int len = source.length();
        assert (len == sourceToDest.length());
        for (int i = 0; i < len; ++i) {
            int j = sourceToDest.data[i];
            this.addAt(j, source.data[i] * factor);
        }
    }

    public void addMultiple(AVector source, Index sourceToDest, double factor) {
        if (sourceToDest.length() != source.length()) {
            throw new VectorzException("Index must match source vector");
        }
        int len = source.length();
        assert (len == sourceToDest.length());
        for (int i = 0; i < len; ++i) {
            int j = sourceToDest.data[i];
            this.addAt(j, source.get(i) * factor);
        }
    }

    public void addMultiple(Index destToSource, Vector source, double factor) {
        if (destToSource.length() != this.length()) {
            throw new VectorzException("Index must match this vector");
        }
        int len = this.length();
        assert (len == destToSource.length());
        for (int i = 0; i < len; ++i) {
            int j = destToSource.data[i];
            this.addAt(i, source.data[j] * factor);
        }
    }

    public void addMultiple(Index destToSource, AVector source, double factor) {
        if (destToSource.length() != this.length()) {
            throw new VectorzException("Index must match this vector");
        }
        int len = this.length();
        assert (len == destToSource.length());
        for (int i = 0; i < len; ++i) {
            int j = destToSource.data[i];
            this.addAt(i, source.get(j) * factor);
        }
    }

    public void set(AVector v, Index indexes) {
        int len = this.length();
        assert (indexes.length() == len);
        for (int i = 0; i < len; ++i) {
            this.set(i, v.get(indexes.get(i)));
        }
    }

    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        assert (offset + length <= this.length());
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + this.get(i + offset);
        }
    }

    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        assert (offset >= 0);
        assert (offset + length <= this.length());
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.get(i + offset);
        }
    }

    public void addProductToArray(double factor, int offset, AVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        if (other instanceof ArrayVector) {
            this.addProductToArray(factor, offset, (ArrayVector)other, otherOffset, array, arrayOffset, length);
            return;
        }
        assert (offset >= 0);
        assert (offset + length <= this.length());
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.get(i + offset) * other.get(i + otherOffset);
        }
    }

    public void addProductToArray(double factor, int offset, ArrayVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        assert (offset >= 0);
        assert (offset + length <= this.length());
        double[] otherArray = other.getArray();
        otherOffset += other.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.get(i + offset) * otherArray[i + otherOffset];
        }
    }

    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            this.addAt(i, a.get(i + aOffset) * b.get(i + bOffset) * factor);
        }
    }

    @Override
    public void applyOp(IOp op) {
        if (op instanceof Op) {
            this.applyOp((Op)op);
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, op.apply(this.get(i)));
        }
    }

    @Override
    public void applyOp(Op op) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, op.apply(this.get(i)));
        }
    }

    public void addAt(int i, double v) {
        this.set(i, this.get(i) + v);
    }

    public void scaleAdd(double factor, double constant) {
        this.scale(factor);
        this.add(constant);
    }

    public void add(double constant) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.addAt(i, constant);
        }
    }

    @Override
    public abstract AVector exactClone();

    public boolean equalsArray(double[] data) {
        int len = this.length();
        if (len != data.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.get(i) == data[i]) continue;
            return false;
        }
        return true;
    }

    public void set(int offset, double[] data, int dataOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.set(offset + i, data[dataOffset + i]);
        }
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        if (tdims < 1) {
            throw new VectorzException("Can't broadcast to a smaller shape!");
        }
        if (tdims == 1) {
            return this;
        }
        if (tdims == 2) {
            int n = targetShape[0];
            AVector[] vs = new AVector[n];
            for (int i = 0; i < n; ++i) {
                vs[i] = this;
            }
            return Matrixx.createFromVectors(vs);
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }
}

