/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.APrimitiveVector;
import mikera.vectorz.Op;

public final class Vector4
extends APrimitiveVector {
    private static final long serialVersionUID = -6018622211027585397L;
    public double x;
    public double y;
    public double z;
    public double t;

    public Vector4() {
    }

    public Vector4(Vector4 source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.t = source.t;
    }

    public Vector4(double x, double y, double z, double t) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    public Vector4(double ... values) {
        if (values.length != this.length()) {
            throw new IllegalArgumentException("Can't create " + this.length() + "D vector from: " + values);
        }
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
        this.t = values[3];
    }

    public static Vector4 of(double x, double y, double z, double t) {
        return new Vector4(x, y, z, t);
    }

    public static Vector4 of(double ... values) {
        return new Vector4(values);
    }

    @Override
    public void applyOp(Op op) {
        this.x = op.apply(this.x);
        this.y = op.apply(this.y);
        this.z = op.apply(this.z);
        this.t = op.apply(this.t);
    }

    public void add(double dx, double dy, double dz, double dt) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        this.t += dt;
    }

    public void set(Vector4 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.t = a.t;
    }

    public void addMultiple(double dx, double dy, double dz, double dt, double factor) {
        this.x += dx * factor;
        this.y += dy * factor;
        this.z += dz * factor;
        this.t += dt * factor;
    }

    public double dotProduct(Vector4 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z + this.t * a.t;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public double elementSum() {
        return this.x + this.y + this.z + this.t;
    }

    @Override
    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.t;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    @Override
    public void set(int i, double value) {
        switch (i) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
            case 3: {
                this.t = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    public void setValues(double x, double y, double z, double t) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    @Override
    public Vector4 clone() {
        return new Vector4(this.x, this.y, this.z, this.t);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getT() {
        return this.t;
    }

    @Override
    public Vector4 exactClone() {
        return this.clone();
    }
}

