/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class RepeatedElementVector
extends AVector {
    private final int dimensions;
    private double value;

    public RepeatedElementVector(int dims) {
        this.dimensions = dims;
    }

    public RepeatedElementVector(int dims, double value) {
        this.dimensions = dims;
        this.value = value;
    }

    public static RepeatedElementVector create(int dims, double value) {
        RepeatedElementVector r = new RepeatedElementVector(dims);
        r.value = value;
        return r;
    }

    @Override
    public int length() {
        return this.dimensions;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public double get(int i) {
        assert (i >= 0 && i < this.dimensions);
        return this.value;
    }

    @Override
    public void scale(double factor) {
        this.value *= factor;
    }

    @Override
    public void set(int i, double value) {
        assert (i >= 0 && i < this.dimensions);
        this.value = value;
    }

    @Override
    public RepeatedElementVector exactClone() {
        return new RepeatedElementVector(this.dimensions, this.value);
    }
}

