/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AScalar;
import mikera.vectorz.impl.DoubleScalar;
import mikera.vectorz.util.VectorzException;

public class ArrayIndexScalar
extends AScalar {
    final double[] array;
    final int index;

    public ArrayIndexScalar(double[] array, int index) {
        this.array = array;
        this.index = index;
    }

    @Override
    public double get() {
        return this.array[this.index];
    }

    @Override
    public void set(double value) {
        this.array[this.index] = value;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public DoubleScalar clone() {
        return new DoubleScalar(this.array[this.index]);
    }

    @Override
    public ArrayIndexScalar exactClone() {
        return new ArrayIndexScalar((double[])this.array.clone(), this.index);
    }

    @Override
    public void validate() {
        if (this.index < 0 || this.index >= this.array.length) {
            throw new VectorzException("Index out of bounds");
        }
        super.validate();
    }
}

