/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.DoubleScalar;

public class VectorIndexScalar
extends AScalar {
    final AVector vector;
    final int index;

    public VectorIndexScalar(AVector vector, int index) {
        assert (index >= 0 && index < vector.length());
        this.vector = vector;
        this.index = index;
    }

    @Override
    public double get() {
        return this.vector.get(this.index);
    }

    @Override
    public void set(double value) {
        this.vector.set(this.index, value);
    }

    @Override
    public boolean isMutable() {
        return this.vector.isFullyMutable();
    }

    @Override
    public boolean isFullyMutable() {
        return this.vector.isFullyMutable();
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public DoubleScalar clone() {
        return new DoubleScalar(this.get());
    }

    @Override
    public VectorIndexScalar exactClone() {
        return new VectorIndexScalar(this.vector.clone(), this.index);
    }
}

