/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.RowMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;

public class ColumnMatrix
extends AMatrix {
    private final AVector vector;

    public ColumnMatrix(AVector v) {
        this.vector = v;
    }

    public static ColumnMatrix wrap(AVector v) {
        return new ColumnMatrix(v);
    }

    @Override
    public int rowCount() {
        return this.vector.length();
    }

    @Override
    public int columnCount() {
        return 1;
    }

    @Override
    public void applyOp(Op op) {
        this.vector.applyOp(op);
    }

    @Override
    public void multiply(double factor) {
        this.vector.scale(factor);
    }

    @Override
    public double elementSum() {
        return this.vector.elementSum();
    }

    @Override
    public long nonZeroCount() {
        return this.vector.nonZeroCount();
    }

    @Override
    public double get(int row, int column) {
        assert (column == 0);
        return this.vector.get(row);
    }

    @Override
    public void set(int row, int column, double value) {
        assert (column == 0);
        this.vector.set(row, value);
    }

    @Override
    public RowMatrix getTranspose() {
        return new RowMatrix(this.vector);
    }

    @Override
    public Vector toVector() {
        return this.vector.toVector();
    }

    @Override
    public AVector asVector() {
        return this.vector;
    }

    @Override
    public ColumnMatrix exactClone() {
        return new ColumnMatrix(this.vector.exactClone());
    }
}

