/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.impl.ArrayMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.util.VectorzException;

public class StridedMatrix
extends ArrayMatrix {
    private final int rowStride;
    private final int colStride;
    private final int offset;

    private StridedMatrix(double[] data, int rowCount, int columnCount, int offset, int rowStride, int columnStride) {
        super(data, rowCount, columnCount);
        this.offset = offset;
        this.rowStride = rowStride;
        this.colStride = columnStride;
    }

    public static StridedMatrix create(int rowCount, int columnCount) {
        double[] data = new double[rowCount * columnCount];
        return new StridedMatrix(data, rowCount, columnCount, 0, columnCount, 1);
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.cols;
    }

    @Override
    public AVector getRow(int i) {
        return StridedVector.wrap(this.data, this.offset + i * this.rowStride, this.cols, this.colStride);
    }

    @Override
    public AVector getColumn(int i) {
        return StridedVector.wrap(this.data, this.offset + i * this.colStride, this.rows, this.rowStride);
    }

    @Override
    public boolean isPackedArray() {
        return this.offset == 0 && this.colStride == 1 && this.rowStride == this.cols && this.data.length == this.rows * this.cols;
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int row = 0; row < rc; ++row) {
            for (int col = 0; col < cc; ++col) {
                int index = this.index(row, col);
                double v = this.data[index];
                this.data[index] = op.apply(v);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        int di = destOffset;
        for (int row = 0; row < rc; ++row) {
            for (int col = 0; col < cc; ++col) {
                int index = this.index(row, col);
                double v = this.data[index];
                dest[di++] = v;
            }
        }
    }

    @Override
    public StridedMatrix getTranspose() {
        return StridedMatrix.wrap(this.data, this.cols, this.rows, this.offset, this.colStride, this.rowStride);
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || column < 0 || row >= this.rows || column >= this.cols) {
            throw new IndexOutOfBoundsException("[" + row + "," + column + "]");
        }
        return this.data[this.index(row, column)];
    }

    @Override
    public AVector asVector() {
        if (this.isPackedArray()) {
            return Vector.wrap(this.data);
        }
        return super.asVector();
    }

    @Override
    public void set(int row, int column, double value) {
        if (row < 0 || column < 0 || row >= this.rows || column >= this.cols) {
            throw new IndexOutOfBoundsException("[" + row + "," + column + "]");
        }
        this.data[this.index((int)row, (int)column)] = value;
    }

    @Override
    public AMatrix exactClone() {
        return new StridedMatrix((double[])this.data.clone(), this.rows, this.cols, this.offset, this.rowStride, this.colStride);
    }

    public static StridedMatrix create(AMatrix m) {
        StridedMatrix sm = StridedMatrix.create(m.rowCount(), m.columnCount());
        sm.set(m);
        return sm;
    }

    public static StridedMatrix wrap(Matrix m) {
        return new StridedMatrix(m.data, m.rowCount(), m.columnCount(), 0, m.columnCount(), 1);
    }

    public static StridedMatrix wrap(double[] data, int rows, int columns, int offset, int rowStride, int columnStride) {
        return new StridedMatrix(data, rows, columns, offset, rowStride, columnStride);
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.equals(this)) {
            throw new VectorzException("Universe destroyed: thing not equal to itself");
        }
        if (this.offset < 0) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
        if (this.index(this.rows - 1, this.cols - 1) >= this.data.length) {
            throw new VectorzException("Negative offset! [" + this.offset + "]");
        }
    }

    private final int index(int row, int col) {
        return this.offset + row * this.rowStride + col * this.colStride;
    }

    @Override
    public Matrix clone() {
        return Matrix.create(this);
    }
}

