/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.ISparse;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;

public final class SubsetMatrix
extends AMatrix
implements ISparse {
    private int inputDims;
    private Index components;

    private SubsetMatrix(int inputDimensions, Index components) {
        this.inputDims = inputDimensions;
        this.components = components;
    }

    public static SubsetMatrix create(Index components, int inputDimensions) {
        return new SubsetMatrix(inputDimensions, components);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source, this.components);
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public int inputDimensions() {
        return this.inputDims;
    }

    @Override
    public int outputDimensions() {
        return this.components.length();
    }

    @Override
    public double elementSum() {
        return this.rowCount();
    }

    @Override
    public long nonZeroCount() {
        return this.rowCount();
    }

    @Override
    public int rowCount() {
        return this.outputDimensions();
    }

    @Override
    public int columnCount() {
        return this.inputDimensions();
    }

    @Override
    public double density() {
        return 1.0 / (double)this.inputDims;
    }

    @Override
    public double get(int row, int column) {
        return column == this.components.get(row) ? 1.0 : 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("Can't set matrix values on: " + this.getClass().getName());
    }

    @Override
    public SubsetMatrix exactClone() {
        return SubsetMatrix.create(this.components.clone(), this.inputDims);
    }
}

