/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Arrays;
import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.VectorzException;

public final class Vector
extends ArrayVector {
    private static final long serialVersionUID = 6283741614665875877L;
    public final double[] data;

    Vector(double ... values) {
        this.data = values;
    }

    Vector(Object ... values) {
        int len = values.length;
        this.data = new double[len];
        for (int i = 0; i < len; ++i) {
            this.data[i] = Tools.toDouble(values[i]);
        }
    }

    Vector(int length) {
        this.data = new double[length];
    }

    public Vector(AVector source) {
        int length = source.length();
        this.data = new double[length];
        source.copyTo(this.data, 0);
    }

    public static Vector wrap(double[] source) {
        return new Vector(source);
    }

    public static Vector of(double ... values) {
        int length = values.length;
        double[] data = new double[length];
        System.arraycopy(values, 0, data, 0, length);
        return Vector.wrap(data);
    }

    public static Vector createLength(int length) {
        return new Vector(length);
    }

    public static Vector create(AVector a) {
        int n = a.length();
        Vector v = Vector.createLength(n);
        a.copyTo(v.data);
        return v;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public void set(int offset, double[] data, int dataOffset, int length) {
        System.arraycopy(data, dataOffset, this.data, offset, length);
    }

    @Override
    public void set(AVector a) {
        if (a instanceof Vector) {
            if (a == this) {
                return;
            }
            Vector v = (Vector)a;
            System.arraycopy(v.data, 0, this.data, 0, this.data.length);
        } else {
            super.set(a);
        }
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.data.length);
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data, 0, this.data.length);
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void clamp(double min, double max) {
        DoubleArrays.clamp(this.data, 0, this.data.length, min, max);
    }

    @Override
    public void square() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double x = this.data[i];
            this.data[i] = x * x;
        }
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += this.data[i];
        }
        return result;
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data, 0, this.data.length);
    }

    @Override
    public void signum() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Math.signum(this.data[i]);
        }
    }

    @Override
    public void abs() {
        for (int i = 0; i < this.data.length; ++i) {
            double val = this.data[i];
            if (!(val < 0.0)) continue;
            this.data[i] = -val;
        }
    }

    @Override
    public void add(ArrayVector src, int srcOffset) {
        int length = this.length();
        assert (srcOffset >= 0);
        assert (srcOffset + length <= src.length());
        double[] vdata = src.getArray();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i];
        }
    }

    @Override
    public void addMultiple(ArrayVector v, double factor) {
        int length = this.length();
        assert (length == v.length());
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public void add(AVector v) {
        if (v instanceof ArrayVector) {
            this.add((ArrayVector)v, 0);
            return;
        }
        int length = this.length();
        assert (length == v.length());
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.get(i);
        }
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            this.data[i] = factor * this.data[i] + constant;
        }
    }

    @Override
    public void add(double constant) {
        DoubleArrays.add(this.data, 0, this.data.length, constant);
    }

    @Override
    public void addProduct(AVector a, AVector b) {
        if (a instanceof Vector && b instanceof Vector) {
            this.addProduct((Vector)a, (Vector)b);
            return;
        }
        super.addProduct(a, b);
    }

    public void addProduct(Vector a, Vector b) {
        int length = this.length();
        assert (a.length() == length && b.length() == length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + a.data[i] * b.data[i];
        }
    }

    public void addProduct(Vector a, Vector b, double factor) {
        int length = this.length();
        assert (a.length() == length && b.length() == length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + a.data[i] * b.data[i] * factor;
        }
    }

    @Override
    public void addAt(int i, double v) {
        int n = i;
        this.data[n] = this.data[n] + v;
    }

    @Override
    public void sub(AVector v) {
        if (v instanceof ArrayVector) {
            this.sub((ArrayVector)v);
            return;
        }
        int length = this.length();
        assert (length == v.length());
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - v.get(i);
        }
    }

    @Override
    public double dotProduct(AVector v, Index ix) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v, ix);
        }
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.get(i);
        }
        return result;
    }

    public double dotProduct(Vector v, Index ix) {
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.data[i];
        }
        return result;
    }

    @Override
    public double dotProduct(AVector v) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v);
        }
        int len = this.length();
        assert (v.length() == len);
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.data[i] * v.get(i);
        }
        return result;
    }

    public double dotProduct(Vector v) {
        int len = this.length();
        assert (v.length() == len);
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.data[i] * v.data[i];
        }
        return result;
    }

    public double distanceSquared(Vector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.data[i] - v.data[i];
            total += d * d;
        }
        return total;
    }

    public double distance(Vector v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    @Override
    public double distance(AVector v) {
        if (v instanceof Vector) {
            return this.distance((Vector)v);
        }
        return super.distance(v);
    }

    public void sub(ArrayVector v) {
        this.sub(v, 0);
    }

    public void sub(ArrayVector src, int srcOffset) {
        int length = this.length();
        assert (length == src.length());
        double[] srcData = src.getArray();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - srcData[voffset + i];
        }
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        if (v instanceof ArrayVector) {
            this.addMultiple((ArrayVector)v, factor);
            return;
        }
        v.addMultipleToArray(factor, 0, this.data, 0, this.length());
    }

    @Override
    public void addWeighted(AVector v, double factor) {
        if (v instanceof ArrayVector) {
            this.addWeighted((ArrayVector)v, factor);
            return;
        }
        int length = this.length();
        assert (length == v.length());
        for (int i = 0; i < length; ++i) {
            this.data[i] = this.data[i] * (1.0 - factor) + v.get(i) * factor;
        }
    }

    public void addWeighted(ArrayVector v, double factor) {
        int length = this.length();
        assert (length == v.length());
        double[] arr = v.getArray();
        int offset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            this.data[i] = this.data[i] * (1.0 - factor) + arr[i + offset] * factor;
        }
    }

    @Override
    public void addMultiple(Vector source, Index index, double factor) {
        if (index.length() != source.length()) {
            throw new VectorzException("Index must match source vector");
        }
        int len = source.length();
        assert (len == index.length());
        for (int i = 0; i < len; ++i) {
            int j;
            int n = j = index.data[i];
            this.data[n] = this.data[n] + source.data[i] * factor;
        }
    }

    @Override
    public void addMultiple(Index destToSource, Vector source, double factor) {
        if (destToSource.length() != this.length()) {
            throw new VectorzException("Index must match this vector");
        }
        int len = this.length();
        assert (len == destToSource.length());
        int i = 0;
        while (i < len) {
            int j = destToSource.data[i];
            int n = i++;
            this.data[n] = this.data[n] + source.data[j] * factor;
        }
    }

    @Override
    public void multiply(double factor) {
        int len = this.length();
        int i = 0;
        while (i < len) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void multiply(AVector v) {
        if (v instanceof Vector) {
            this.multiply((Vector)v);
            return;
        }
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * v.get(i));
        }
    }

    public void multiply(Vector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.data[i] * v.data[i]);
        }
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public Vector clone() {
        return new Vector(this);
    }

    @Override
    public Vector exactClone() {
        return this.clone();
    }

    @Override
    public boolean isPackedArray() {
        return true;
    }
}

