/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Iterator;
import mikera.vectorz.AVector;

public final class VectorIterator
implements Iterator<Double> {
    private final AVector source;
    private final int maxPos;
    private int pos;

    public VectorIterator(AVector source) {
        this.pos = 0;
        this.source = source;
        this.maxPos = source.length();
    }

    public VectorIterator(AVector source, int start, int length) {
        this.pos = start;
        this.source = source;
        this.maxPos = start + length;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.maxPos;
    }

    @Override
    public Double next() {
        assert (this.pos < this.maxPos);
        return this.source.get(this.pos++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from VectorIterator");
    }
}

