/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;
import mikera.util.Rand;
import mikera.vectorz.AVector;
import mikera.vectorz.IVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vector1;
import mikera.vectorz.Vector2;
import mikera.vectorz.Vector3;
import mikera.vectorz.Vector4;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.impl.ZeroVector;
import mikera.vectorz.util.VectorBuilder;
import mikera.vectorz.util.VectorzException;
import us.bpsm.edn.parser.CollectionBuilder;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;

public class Vectorz {
    public static final double TEST_EPSILON = 1.0E-7;
    private static final AVector[] ZERO_VECTORS = new AVector[]{Vector0.INSTANCE, new ZeroVector(1), new ZeroVector(2), new ZeroVector(3), new ZeroVector(4)};

    public static AVector create(double ... data) {
        switch (data.length) {
            case 0: {
                return Vector0.INSTANCE;
            }
            case 1: {
                return Vector1.of(data);
            }
            case 2: {
                return Vector2.of(data);
            }
            case 3: {
                return Vector3.of(data);
            }
            case 4: {
                return Vector4.of(data);
            }
        }
        return Vector.of(data);
    }

    public static AVector join(AVector first, AVector second) {
        AVector result = first.join(second);
        assert (result.length() == first.length() + second.length());
        return result;
    }

    public static AVector join(AVector ... vectors) {
        AVector result = vectors[0];
        for (int i = 1; i < vectors.length; ++i) {
            result = result.join(vectors[i]);
        }
        return result;
    }

    public static AVector join(List<AVector> vectors) {
        int count = vectors.size();
        AVector v = vectors.get(0);
        for (int i = 1; i < count; ++i) {
            v = v.join(vectors.get(i));
        }
        return v;
    }

    public static AVector createZeroVector(int length) {
        return Vectorz.newVector(length);
    }

    public static Vector wrap(double[] data) {
        return Vector.wrap(data);
    }

    public static AVector wrap(double[][] data) {
        if (data.length == 0) {
            return Vector0.INSTANCE;
        }
        AVector v = Vectorz.wrap(data[0]);
        for (int i = 1; i < data.length; ++i) {
            v = Vectorz.join(v, (AVector)Vectorz.wrap(data[i]));
        }
        return v;
    }

    public static AVector wrap(double[] data, int offset, int length) {
        if (offset == 0 && length == data.length) {
            return Vectorz.wrap(data);
        }
        return ArraySubVector.wrap(data, offset, length);
    }

    public static AVector wrapStrided(double[] data, int offset, int length, int stride) {
        if (stride == 1) {
            return ArraySubVector.wrap(data, offset, length);
        }
        return StridedVector.wrapStrided(data, offset, length, stride);
    }

    public static AVector newVector(int length) {
        switch (length) {
            case 0: {
                return Vector0.INSTANCE;
            }
            case 1: {
                return new Vector1();
            }
            case 2: {
                return new Vector2();
            }
            case 3: {
                return new Vector3();
            }
            case 4: {
                return new Vector4();
            }
        }
        return new Vector(length);
    }

    public static AVector createSameSize(AVector v) {
        return Vectorz.newVector(v.length());
    }

    public static AVector create(AVector vector) {
        if (!vector.isView()) {
            return vector.clone();
        }
        AVector nv = Vectorz.newVector(vector.length());
        vector.copyTo(nv, 0);
        return nv;
    }

    public static AVector create(IVector vector) {
        AVector nv = Vectorz.newVector(vector.length());
        nv.set(vector);
        return nv;
    }

    public static void copy(AVector source, int srcOffset, AVector dest, int destOffset, int length) {
        source.copyTo(srcOffset, dest, destOffset, length);
    }

    public static AVector createUniformRandomVector(int dimensions) {
        AVector v = Vectorz.newVector(dimensions);
        for (int i = 0; i < dimensions; ++i) {
            v.set(i, Rand.nextDouble());
        }
        return v;
    }

    public static AVector createMutableVector(AVector t) {
        AVector v = Vectorz.newVector(t.length());
        v.set(t);
        return v;
    }

    public static AVector immutableZeroVector(int dimensions) {
        if (dimensions >= ZERO_VECTORS.length) {
            return new ZeroVector(dimensions);
        }
        return ZERO_VECTORS[dimensions];
    }

    private static Parser.Config getVectorParserConfig() {
        return ParserConfigHolder.parserConfig;
    }

    public static AVector parse(String ednString) {
        Parser p = Parsers.newParser((Parser.Config)Vectorz.getVectorParserConfig());
        return (AVector)p.nextValue(Parsers.newParseable((CharSequence)ednString));
    }

    public static AVector create(List<Object> d) {
        int length = d.size();
        AVector v = Vectorz.newVector(length);
        for (int i = 0; i < length; ++i) {
            v.set(i, Tools.toDouble(d.get(i)));
        }
        return v;
    }

    public static AVector create(DoubleBuffer d) {
        int length = d.remaining();
        Vector v = Vector.createLength(length);
        d.get(v.data, 0, length);
        return v;
    }

    public static AVector create(Iterable<Object> d) {
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object o : d) {
            al.add(o);
        }
        return Vectorz.create(al);
    }

    public static double minValue(AVector v) {
        int len = v.length();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < len; ++i) {
            double d = v.get(i);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static int indexOfMinValue(AVector v) {
        int len = v.length();
        double min = v.get(0);
        int ind = 0;
        for (int i = 1; i < len; ++i) {
            double d = v.get(i);
            if (!(d < min)) continue;
            min = d;
            ind = i;
        }
        return ind;
    }

    public static double maxValue(AVector v) {
        int len = v.length();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < len; ++i) {
            double d = v.get(i);
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static int indexOfMaxValue(AVector v) {
        int len = v.length();
        double max = v.get(0);
        int ind = 0;
        for (int i = 1; i < len; ++i) {
            double d = v.get(i);
            if (!(d > max)) continue;
            max = d;
            ind = i;
        }
        return ind;
    }

    public static void invSqrt(AVector v) {
        if (v instanceof Vector) {
            Vectorz.invSqrt((Vector)v);
            return;
        }
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            double d = 1.0 / Math.sqrt(v.get(i));
            v.set(i, d);
        }
    }

    public static void invSqrt(Vector v) {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            double d;
            v.data[i] = d = 1.0 / Math.sqrt(v.data[i]);
        }
    }

    public static double totalValue(AVector v) {
        int len = v.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += v.get(i);
        }
        return result;
    }

    public static double averageValue(AVector v) {
        int len = v.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += v.get(i);
        }
        return result / (double)len;
    }

    public static double averageSquaredDifference(AVector a, AVector b) {
        int len = a.length();
        assert (len == b.length());
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = a.get(i) - b.get(i);
            result += d * d;
        }
        return result / (double)len;
    }

    public static double rmsDifference(AVector a, AVector b) {
        return Math.sqrt(Vectorz.averageSquaredDifference(a, b));
    }

    public static void fillRandom(AVector v) {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            v.set(i, Rand.nextDouble());
        }
    }

    public static void fillGaussian(AVector v) {
        Vectorz.fillGaussian(v, 0.0, 1.0);
    }

    public static void fillIndexes(AVector v) {
        int n = v.length();
        for (int i = 0; i < n; ++i) {
            v.set(i, (double)i);
        }
    }

    public static void fillGaussian(AVector v, double mean, double sd) {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            v.set(i, mean + Rand.nextGaussian() * sd);
        }
    }

    public static void fillBinaryRandom(AVector v) {
        Vectorz.fillBinaryRandom(v, 0.5);
    }

    public static AVector axisVector(int axisIndex, int dimensions) {
        AVector v = Vectorz.newVector(dimensions);
        v.set(axisIndex, 1.0);
        return v;
    }

    public static void fillBinaryRandom(AVector v, double prob) {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            v.set(i, Rand.binary((double)prob));
        }
    }

    public static AVector toVector(Object o) {
        if (o instanceof AVector) {
            return (AVector)o;
        }
        if (o instanceof double[]) {
            return Vectorz.create((double[])o);
        }
        if (o instanceof List) {
            return Vectorz.create((List)o);
        }
        if (o instanceof Iterable) {
            return Vectorz.create((Iterable)o);
        }
        throw new UnsupportedOperationException("Cannot coerce to AVector: " + o.getClass());
    }

    public static AVector create(Object o) {
        if (o instanceof Double) {
            return Vector1.of(Tools.toDouble(o));
        }
        return Vectorz.toVector(o);
    }

    public static AVector createRange(int length) {
        AVector v = Vectorz.newVector(length);
        for (int i = 0; i < length; ++i) {
            v.set(i, (double)i);
        }
        return v;
    }

    private static class ParserConfigHolder {
        static final Parser.Config parserConfig;

        private ParserConfigHolder() {
        }

        static {
            Parser.Config.Builder b = Parsers.newParserConfigBuilder();
            b.setVectorFactory(new CollectionBuilder.Factory(){

                public CollectionBuilder builder() {
                    return new CollectionBuilder(){
                        VectorBuilder b = new VectorBuilder();

                        public void add(Object o) {
                            double d;
                            if (o instanceof Double) {
                                d = (Double)o;
                            } else if (o instanceof Number) {
                                d = ((Number)o).doubleValue();
                            } else {
                                throw new VectorzException("Cannot parse double value from class: " + o.getClass());
                            }
                            this.b.add(d);
                        }

                        public Object build() {
                            return this.b.toVector();
                        }
                    };
                }
            });
            parserConfig = b.build();
        }
    }
}

