/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class RepeatedElementVector
extends AVector {
    private final int dimensions;
    private final double value;

    public RepeatedElementVector(int dims, double value) {
        this.dimensions = dims;
        this.value = value;
    }

    public static RepeatedElementVector create(int dims, double value) {
        RepeatedElementVector r = new RepeatedElementVector(dims, value);
        return r;
    }

    @Override
    public int length() {
        return this.dimensions;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public double get(int i) {
        assert (i >= 0 && i < this.dimensions);
        return this.value;
    }

    @Override
    public double elementSum() {
        return (double)this.dimensions * this.value;
    }

    @Override
    public long nonZeroCount() {
        return this.value == 0.0 ? 0L : (long)this.dimensions;
    }

    @Override
    public void set(int i, double value) {
        throw new UnsupportedOperationException(this.getClass().toString() + " is not mutable");
    }

    @Override
    public RepeatedElementVector exactClone() {
        return new RepeatedElementVector(this.dimensions, this.value);
    }
}

