/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.VectorzException;

public final class StridedVector
extends AVector {
    private static final long serialVersionUID = 5807998427323932401L;
    private final double[] data;
    private final int length;
    private final int offset;
    private final int stride;

    private StridedVector(double[] data, int offset, int length, int stride) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.stride = stride;
    }

    public static StridedVector wrapStrided(double[] data, int offset, int length, int stride) {
        return new StridedVector(data, offset, length, stride);
    }

    public static StridedVector wrap(double[] data, int offset, int length, int stride) {
        return StridedVector.wrapStrided(data, offset, length, stride);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public double dotProduct(AVector v) {
        assert (v.length() == this.length);
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.data[this.offset + i * this.stride] * v.get(i);
        }
        return result;
    }

    @Override
    public void set(AVector v) {
        assert (v.length() == this.length);
        for (int i = 0; i < this.length; ++i) {
            this.data[this.offset + i * this.stride] = v.get(i);
        }
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (length == 1) {
            return ArraySubVector.wrap(this.data, this.offset + start * this.stride, 1);
        }
        if (length > 0) {
            return StridedVector.wrapStrided(this.data, this.offset + start * this.stride, length, this.stride);
        }
        return Vector0.INSTANCE;
    }

    @Override
    public double get(int i) {
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public void set(int i, double value) {
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int n = this.offset + i * this.stride;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void copyTo(double[] dest, int destOffset) {
        for (int i = 0; i < this.length; ++i) {
            dest[destOffset + i] = this.data[this.offset + i * this.stride];
        }
    }

    @Override
    public StridedVector exactClone() {
        double[] data = (double[])this.data.clone();
        return StridedVector.wrapStrided(data, this.offset, this.length, this.stride);
    }

    @Override
    public void validate() {
        if (this.length > 0) {
            if (this.offset < 0 || this.offset >= this.data.length) {
                throw new VectorzException("offset out of bounds: " + this.offset);
            }
            int lastIndex = this.offset + this.stride * (this.length - 1);
            if (lastIndex < 0 || lastIndex >= this.data.length) {
                throw new VectorzException("lastIndex out of bounds: " + lastIndex);
            }
        }
        super.validate();
    }
}

