/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import mikera.arrayz.Array;
import mikera.arrayz.INDArray;
import mikera.arrayz.NDArray;
import mikera.arrayz.SliceArray;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.Scalar;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;

public class Arrayz {
    public static INDArray create(Object object) {
        if (object instanceof INDArray) {
            return ((INDArray)object).clone();
        }
        if (object instanceof double[]) {
            return Vector.of((double[])object);
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return Vector0.INSTANCE;
            }
            Object o1 = list.get(0);
            if (o1 instanceof AScalar || o1 instanceof Number) {
                return Vectorz.create((List)object);
            }
            if (o1 instanceof AVector) {
                return Matrixx.create((List)object);
            }
            if (o1 instanceof INDArray) {
                return SliceArray.create((List)object);
            }
            ArrayList<INDArray> al = new ArrayList<INDArray>();
            for (Object o : list) {
                al.add(Arrayz.create(o));
            }
            return Arrayz.create(al);
        }
        if (object instanceof Number) {
            return Scalar.create(((Number)object).doubleValue());
        }
        throw new VectorzException("Don't know how to create array from: " + object.getClass());
    }

    public static INDArray newArray(int ... shape) {
        int dims = shape.length;
        switch (dims) {
            case 0: {
                return Scalar.create(0.0);
            }
            case 1: {
                return Vector.createLength(shape[0]);
            }
            case 2: {
                return Matrix.create(shape[0], shape[1]);
            }
        }
        return Array.newArray(shape);
    }

    public static INDArray create(Object ... data) {
        int n = data.length;
        INDArray[] as = new INDArray[n];
        for (int i = 0; i < n; ++i) {
            as[i] = Arrayz.create((Object)data);
        }
        return SliceArray.create((INDArray[])as);
    }

    public static INDArray wrap(double[] data, int[] shape) {
        switch (shape.length) {
            case 0: {
                return ArrayIndexScalar.wrap(data, 0);
            }
            case 1: {
                int n = shape[0];
                if (n == data.length) {
                    return Vector.wrap(data);
                }
                return ArraySubVector.wrap(data, 0, n);
            }
            case 2: {
                int rc = shape[0];
                int cc = shape[1];
                if (rc * cc == data.length) {
                    return Matrix.wrap(rc, cc, data);
                }
                return NDArray.wrap(data, shape);
            }
        }
        return NDArray.wrap(data, shape);
    }

    public static INDArray createFromVector(AVector a, int ... shape) {
        int dims = shape.length;
        if (dims == 0) {
            return Scalar.createFromVector(a);
        }
        if (dims == 1) {
            return Vector.createFromVector(a, shape[0]);
        }
        if (dims == 2) {
            return Matrixx.createFromVector(a, shape[0], shape[1]);
        }
        return Array.createFromVector(a, shape);
    }

    public static INDArray load(Reader reader) {
        Parseable pbr = Parsers.newParseable((Readable)reader);
        Parser p = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        return Arrayz.create(p.nextValue(pbr));
    }

    public static INDArray parse(String ednString) {
        return Arrayz.load(new StringReader(ednString));
    }

    public static long elementCount(int[] shape) {
        return IntArrays.arrayProduct(shape);
    }
}

