/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADenseArrayMatrix;
import mikera.matrixx.impl.AStridedMatrix;
import mikera.matrixx.impl.StridedMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class Matrix
extends ADenseArrayMatrix {
    public Matrix(int rowCount, int columnCount) {
        this(rowCount, columnCount, new double[rowCount * columnCount]);
    }

    public static Matrix create(int rowCount, int columnCount) {
        return new Matrix(rowCount, columnCount);
    }

    public static Matrix create(AMatrix m) {
        Matrix nm = new Matrix(m.rowCount(), m.columnCount());
        nm.set(m);
        return nm;
    }

    public Matrix(AMatrix m) {
        this(m.rowCount(), m.columnCount());
        this.set(m);
    }

    public Matrix create(Object ... rowVectors) {
        VectorMatrixMN m = VectorMatrixMN.create(rowVectors);
        Matrix r = new Matrix(((AMatrix)m).rowCount(), ((AMatrix)m).columnCount(), new double[this.rows * this.cols]);
        r.set(m);
        return r;
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return DoubleArrays.isBoolean(this.data, 0, this.data.length);
    }

    @Override
    public boolean isPackedArray() {
        return true;
    }

    private Matrix(int rowCount, int columnCount, double[] data) {
        super(data, rowCount, columnCount);
    }

    public static Matrix wrap(int rowCount, int columnCount, double[] data) {
        if (data.length != rowCount * columnCount) {
            throw new VectorzException("data array is of wrong size: " + data.length);
        }
        return new Matrix(rowCount, columnCount, data);
    }

    @Override
    public AStridedMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        if (rowStart < 0 || rowStart >= this.rows || colStart < 0 || colStart >= this.cols) {
            throw new IndexOutOfBoundsException("Invalid submatrix start position");
        }
        if (rowStart + rows > this.rows || colStart + cols > this.cols) {
            throw new IndexOutOfBoundsException("Invalid submatrix end position");
        }
        if (rows < 1 || cols < 1) {
            throw new IllegalArgumentException("Submatrix has no elements");
        }
        return StridedMatrix.wrap(this.data, rows, cols, rowStart * this.rowStride() + colStart * this.columnStride(), this.rowStride(), this.columnStride());
    }

    @Override
    public Vector innerProduct(AVector a) {
        if (a instanceof Vector) {
            return this.innerProduct((Vector)a);
        }
        return this.transform(a);
    }

    public Vector innerProduct(Vector a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (cc != a.length()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        Vector result = Vector.createLength(this.rows);
        for (int i = 0; i < rc; ++i) {
            int di = i * cc;
            double acc = 0.0;
            for (int j = 0; j < cc; ++j) {
                acc += this.data[di + j] * a.data[j];
            }
            result.unsafeSet(i, acc);
        }
        return result;
    }

    @Override
    public Matrix innerProduct(Matrix a) {
        if (this.columnCount() != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.unsafeGet(i, k) * a.unsafeGet(k, j);
                }
                result.unsafeSet(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public Matrix innerProduct(AMatrix a) {
        if (a instanceof Matrix) {
            return this.innerProduct((Matrix)a);
        }
        if (this.columnCount() != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.unsafeGet(i, k) * a.unsafeGet(k, j);
                }
                result.unsafeSet(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data);
    }

    @Override
    public void abs() {
        DoubleArrays.abs(this.data);
    }

    @Override
    public void signum() {
        DoubleArrays.signum(this.data);
    }

    @Override
    public void square() {
        DoubleArrays.square(this.data);
    }

    @Override
    public void exp() {
        DoubleArrays.exp(this.data);
    }

    @Override
    public void log() {
        DoubleArrays.log(this.data);
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data);
    }

    @Override
    public Matrix clone() {
        return new Matrix(this.rows, this.cols, (double[])this.data.clone());
    }

    @Override
    public Vector transform(AVector a) {
        Vector v = Vector.createLength(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            v.data[i] = a.dotProduct(this.data, i * this.cols);
        }
        return v;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (this.rows != dest.length()) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        if (this.cols != source.length()) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            double acc = 0.0;
            for (int j = 0; j < this.cols; ++j) {
                acc += this.data[index++] * source.unsafeGet(j);
            }
            dest.unsafeSet(i, acc);
        }
    }

    @Override
    public ArraySubVector getRow(int row) {
        return ArraySubVector.wrap(this.data, row * this.cols, this.cols);
    }

    @Override
    public AStridedVector getColumn(int col) {
        if (this.cols == 1) {
            return Vector.wrap(this.data);
        }
        return StridedVector.wrap(this.data, col, this.rows, this.cols);
    }

    @Override
    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        int a = i * this.cols;
        int b = j * this.cols;
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = this.data[a + k];
            this.data[a + k] = this.data[b + k];
            this.data[b + k] = t;
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int k = 0; k < rc; ++k) {
            int x = k * cc;
            double t = this.data[i + x];
            this.data[i + x] = this.data[j + x];
            this.data[j + x] = t;
        }
    }

    @Override
    public void multiplyRow(int i, double factor) {
        int offset = i * this.cols;
        for (int j = 0; j < this.cols; ++j) {
            int n = offset + j;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void addRowMultiple(int src, int dst, double factor) {
        int soffset = src * this.cols;
        int doffset = dst * this.cols;
        for (int j = 0; j < this.cols; ++j) {
            int n = doffset + j;
            this.data[n] = this.data[n] + factor * this.data[soffset + j];
        }
    }

    @Override
    public Vector asVector() {
        return Vector.wrap(this.data);
    }

    @Override
    public Vector toVector() {
        return Vector.create(this.data);
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.data);
    }

    @Override
    public double get(int row, int column) {
        if (column < 0 || column >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[row * this.cols + column];
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        this.data[row * this.cols + column] = value;
    }

    @Override
    public double unsafeGet(int row, int column) {
        return this.data[row * this.cols + column];
    }

    @Override
    public void set(int row, int column, double value) {
        if (column < 0 || column >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
        this.data[row * this.cols + column] = value;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data);
    }

    public void addMultiple(Matrix m, double factor) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i] * factor;
        }
    }

    public void add(Matrix m) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i];
        }
    }

    @Override
    public void addMultiple(AMatrix m, double factor) {
        if (m instanceof Matrix) {
            this.addMultiple((Matrix)m, factor);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != m.rowCount() || cc != m.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, m));
        }
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.unsafeGet(i, j) * factor;
            }
        }
    }

    @Override
    public void add(AMatrix m) {
        if (m instanceof Matrix) {
            this.add((Matrix)m);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != m.rowCount() || cc != m.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, m));
        }
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.unsafeGet(i, j);
            }
        }
    }

    @Override
    public void multiply(double factor) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void set(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        int cc = this.columnCount();
        if (cc != a.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        a.getElements(this.data, 0);
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.data.length);
    }

    @Override
    public StridedMatrix getTranspose() {
        return StridedMatrix.wrap(this.data, this.cols, this.rows, 0, 1, this.cols);
    }

    @Override
    public StridedMatrix getTransposeView() {
        return StridedMatrix.wrap(this.data, this.cols, this.rows, 0, 1, this.cols);
    }

    @Override
    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void reciprocal() {
        DoubleArrays.reciprocal(this.data, 0, this.data.length);
    }

    @Override
    public void clamp(double min, double max) {
        DoubleArrays.clamp(this.data, 0, this.data.length, min, max);
    }

    @Override
    public Matrix exactClone() {
        return new Matrix(this);
    }

    @Override
    public void setRow(int i, AVector row) {
        int cc = this.columnCount();
        if (row.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this.getRow(i), row));
        }
        row.getElements(this.data, i * cc);
    }

    @Override
    public void setColumn(int j, AVector col) {
        int rc = this.rowCount();
        if (col.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this.getColumn(j), col));
        }
        for (int i = 0; i < rc; ++i) {
            this.data[this.index((int)i, (int)j)] = col.unsafeGet(j);
        }
    }

    @Override
    protected final int index(int row, int col) {
        return row * this.cols + col;
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }
}

