/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.algo;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.algo.Decompositions;
import mikera.vectorz.Vector;

public class QR {
    public static Matrix[] decompose(AMatrix matrix) {
        return QR.decompose(Matrix.create(matrix));
    }

    public static Matrix[] decompose(Matrix matrix) {
        int cc;
        int rc = matrix.rowCount();
        if (rc < (cc = matrix.columnCount())) {
            throw new IllegalArgumentException("Wrong matrix size: rows < columns");
        }
        Matrix qr = matrix.toMatrix();
        Vector rdiag = Vector.createLength(cc);
        for (int k = 0; k < cc; ++k) {
            int i;
            double norm = 0.0;
            for (i = k; i < rc; ++i) {
                norm = Math.hypot(norm, qr.get(i, k));
            }
            if (Math.abs(norm) > Decompositions.EPS) {
                if (qr.get(k, k) < 0.0) {
                    norm = -norm;
                }
                for (i = k; i < rc; ++i) {
                    qr.set(i, k, qr.get(i, k) / norm);
                }
                qr.addAt(k, k, 1.0);
                for (int j = k + 1; j < cc; ++j) {
                    int i2;
                    double summand = 0.0;
                    for (i2 = k; i2 < rc; ++i2) {
                        summand += qr.get(i2, k) * qr.get(i2, j);
                    }
                    summand = -summand / qr.get(k, k);
                    for (i2 = k; i2 < rc; ++i2) {
                        qr.addAt(i2, j, summand * qr.get(i2, k));
                    }
                }
            }
            rdiag.set(k, -norm);
        }
        Matrix q = Matrix.create(rc, cc);
        for (int k = cc - 1; k >= 0; --k) {
            q.set(k, k, 1.0);
            for (int j = k; j < cc; ++j) {
                int i;
                if (!(Math.abs(qr.get(k, k)) > Decompositions.EPS)) continue;
                double summand = 0.0;
                for (i = k; i < rc; ++i) {
                    summand += qr.get(i, k) * q.get(i, j);
                }
                summand = -summand / qr.get(k, k);
                for (i = k; i < rc; ++i) {
                    q.addAt(i, j, summand * qr.get(i, k));
                }
            }
        }
        Matrix r = Matrix.create(cc, cc);
        for (int i = 0; i < cc; ++i) {
            for (int j = i; j < cc; ++j) {
                if (i < j) {
                    r.set(i, j, qr.get(i, j));
                    continue;
                }
                if (i != j) continue;
                r.set(i, j, rdiag.get(i));
            }
        }
        return new Matrix[]{q, r};
    }
}

