/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.algo;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.impl.PermutationMatrix;
import mikera.vectorz.Vector;

public class LU {
    public static AMatrix[] decomposeLUP(AMatrix matrix) {
        return LU.decomposeLUPInternal(Matrix.create(matrix));
    }

    public static AMatrix[] decomposeLUP(Matrix matrix) {
        return LU.decomposeLUPInternal(matrix.clone());
    }

    private static AMatrix[] decomposeLUPInternal(Matrix lu) {
        int i;
        if (!lu.isSquare()) {
            throw new IllegalArgumentException("Wrong matrix size: not square");
        }
        int n = lu.rowCount();
        PermutationMatrix p = PermutationMatrix.createIdentity(n);
        for (int j = 0; j < n; ++j) {
            int i2;
            Vector jcolumn = lu.getColumn(j).toVector();
            for (i = 0; i < n; ++i) {
                int kmax = Math.min(i, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += lu.get(i, k) * jcolumn.get(k);
                }
                jcolumn.set(i, jcolumn.get(i) - s);
                lu.set(i, j, jcolumn.get(i));
            }
            int biggest = j;
            for (i2 = j + 1; i2 < n; ++i2) {
                if (!(Math.abs(jcolumn.get(i2)) > Math.abs(jcolumn.get(biggest)))) continue;
                biggest = i2;
            }
            if (biggest != j) {
                lu.swapRows(biggest, j);
                p.swapRows(biggest, j);
            }
            if (!(j < n & lu.get(j, j) != 0.0)) continue;
            for (i2 = j + 1; i2 < n; ++i2) {
                lu.set(i2, j, lu.get(i2, j) / lu.get(j, j));
            }
        }
        Matrix l = Matrix.create(n, n);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j < i3; ++j) {
                l.set(i3, j, lu.get(i3, j));
            }
            l.set(i3, i3, 1.0);
        }
        Matrix u = lu;
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                u.set(i, j, 0.0);
            }
        }
        return new AMatrix[]{l, u, p};
    }
}

