/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;

public abstract class AArrayMatrix
extends AMatrix {
    protected final int rows;
    protected final int cols;
    public final double[] data;

    protected AArrayMatrix(double[] data, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.data = data;
    }

    @Override
    public final int rowCount() {
        return this.rows;
    }

    @Override
    public final int columnCount() {
        return this.cols;
    }

    @Override
    public double get(int i, int j) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[this.index(i, j)];
    }

    @Override
    public void set(int i, int j, double value) {
        if (i < 0 || i >= this.rows || j < 0 || j >= this.cols) {
            throw new IndexOutOfBoundsException();
        }
        this.data[this.index((int)i, (int)j)] = value;
    }

    @Override
    public double unsafeGet(int i, int j) {
        return this.data[this.index(i, j)];
    }

    @Override
    public void unsafeSet(int i, int j, double value) {
        this.data[this.index((int)i, (int)j)] = value;
    }

    public abstract boolean isPackedArray();

    protected abstract int index(int var1, int var2);

    public double[] getArray() {
        return this.data;
    }
}

