/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.AVectorMatrix;
import mikera.vectorz.AVector;

public final class BroadcastVectorMatrix
extends AVectorMatrix<AVector> {
    private final int rows;
    private final int cols;
    private final AVector vector;

    private BroadcastVectorMatrix(AVector v, int rows) {
        this.rows = rows;
        this.cols = v.length();
        this.vector = v;
    }

    public static BroadcastVectorMatrix wrap(AVector v, int rows) {
        return new BroadcastVectorMatrix(v, rows);
    }

    @Override
    public void appendRow(AVector row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AVector getRow(int row) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("Row: " + row);
        }
        return this.vector;
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.cols;
    }

    @Override
    public AMatrix exactClone() {
        return BroadcastVectorMatrix.wrap(this.vector, this.rows);
    }
}

