/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.RepeatedElementVector;
import mikera.vectorz.util.ErrorMessages;

public class ScalarMatrix
extends ADiagonalMatrix {
    private double scale;

    public ScalarMatrix(int dimensions, double scale) {
        super(dimensions);
        this.scale = scale;
    }

    @Override
    public long nonZeroCount() {
        return this.scale == 0.0 ? 0L : (long)this.dimensions;
    }

    @Override
    public double elementSum() {
        return this.scale * (double)this.dimensions;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || row >= this.dimensions || column < 0 || column >= this.dimensions) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return row == column ? this.scale : 0.0;
    }

    @Override
    public double unsafeGet(int row, int column) {
        return row == column ? this.scale : 0.0;
    }

    @Override
    public AVector getLeadingDiagonal() {
        return RepeatedElementVector.create(this.dimensions, this.scale);
    }

    public static AMatrix create(int dimensions, double scale) {
        return new ScalarMatrix(dimensions, scale);
    }

    @Override
    public void multiply(double factor) {
        this.scale *= factor;
    }

    @Override
    public double trace() {
        return this.scale * (double)this.dimensions;
    }

    @Override
    public void transformInPlace(AVector v) {
        v.multiply(this.scale);
    }

    @Override
    public void transformInPlace(AArrayVector v) {
        v.multiply(this.scale);
    }

    @Override
    public ScalarMatrix exactClone() {
        return new ScalarMatrix(this.dimensions, this.scale);
    }
}

