/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.JoinedArrayVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public abstract class AArrayVector
extends AStridedVector {
    @Override
    public final int getStride() {
        return 1;
    }

    @Override
    public ArraySubVector subVector(int offset, int length) {
        int len = this.length();
        if (offset + length > len) {
            throw new IndexOutOfBoundsException("Upper bound " + len + " breached:" + (offset + length));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Lower bound breached:" + offset);
        }
        return new ArraySubVector(this, offset, length);
    }

    @Override
    public AScalar slice(int position) {
        assert (position >= 0 && position < this.length());
        return new ArrayIndexScalar(this.getArray(), this.getArrayOffset() + position);
    }

    @Override
    public boolean isPackedArray() {
        return this.getArrayOffset() == 0 && this.length() == this.getArray().length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void copyTo(double[] data, int offset) {
        System.arraycopy(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public void fillRange(int offset, int length, double value) {
        assert (offset >= 0 && length >= 0 && offset + length <= this.length());
        double[] arr = this.getArray();
        int off = this.getArrayOffset();
        Arrays.fill(arr, off + offset, off + offset + length, value);
    }

    @Override
    public void set(AVector a) {
        assert (a.length() == this.length());
        a.copyTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void set(AVector a, int offset) {
        assert (offset >= 0);
        assert (offset + this.length() <= a.length());
        a.copyTo(offset, this, 0, this.length());
    }

    @Override
    public void setRange(int offset, double[] data, int dataOffset, int length) {
        System.arraycopy(data, dataOffset, this.getArray(), this.getArrayOffset() + offset, length);
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        assert (length == this.length());
        System.arraycopy(values, offset, this.getArray(), this.getArrayOffset(), length);
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.getArray(), this.getArrayOffset(), dest, offset, this.length());
    }

    @Override
    public abstract double get(int var1);

    @Override
    public abstract void set(int var1, double var2);

    @Override
    public abstract double unsafeGet(int var1);

    @Override
    public abstract void unsafeSet(int var1, double var2);

    @Override
    public void add(AVector src) {
        if (src instanceof AArrayVector) {
            this.add((AArrayVector)src, 0);
            return;
        }
        int length = this.length();
        src.addToArray(0, this.getArray(), this.getArrayOffset(), length);
    }

    public void add(AArrayVector v) {
        assert (this.length() == v.length());
        this.add(v, 0);
    }

    @Override
    public void add(AVector src, int srcOffset) {
        if (src instanceof AArrayVector) {
            this.add((AArrayVector)src, srcOffset);
            return;
        }
        int length = this.length();
        src.addToArray(srcOffset, this.getArray(), this.getArrayOffset(), length);
    }

    @Override
    public void add(int offset, AVector src) {
        if (src instanceof AArrayVector) {
            this.add(offset, (AArrayVector)src);
            return;
        }
        int length = src.length();
        src.addToArray(0, this.getArray(), this.getArrayOffset() + offset, length);
    }

    public void add(int offset, AArrayVector src) {
        int length = src.length();
        DoubleArrays.add(src.getArray(), src.getArrayOffset(), this.getArray(), offset + this.getArrayOffset(), length);
    }

    public void add(int offset, AArrayVector src, int srcOffset, int length) {
        DoubleArrays.add(src.getArray(), src.getArrayOffset() + srcOffset, this.getArray(), offset + this.getArrayOffset(), length);
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        if (v instanceof AArrayVector) {
            this.addMultiple((AArrayVector)v, factor);
            return;
        }
        int length = this.length();
        v.addMultipleToArray(factor, 0, this.getArray(), this.getArrayOffset(), length);
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        DoubleArrays.scaleAdd(this.getArray(), this.getArrayOffset(), this.length(), factor, constant);
    }

    @Override
    public void add(double constant) {
        DoubleArrays.add(this.getArray(), this.getArrayOffset(), this.length(), constant);
    }

    @Override
    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        int length = this.length();
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        a.addProductToArray(factor, aOffset, b, bOffset, array, offset, length);
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        double[] data = this.getArray();
        int dataOffset = this.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + data[i + dataOffset];
        }
    }

    @Override
    public void addProduct(AVector a, AVector b, double factor) {
        int len = this.length();
        assert (len == a.length());
        assert (len == b.length());
        double[] array = this.getArray();
        int offset = this.getArrayOffset();
        a.addProductToArray(factor, 0, b, 0, array, offset, len);
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        double[] data = this.getArray();
        int dataOffset = this.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * data[i + dataOffset];
        }
    }

    @Override
    public void addProductToArray(double factor, int offset, AVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        if (other instanceof AArrayVector) {
            this.addProductToArray(factor, offset, (AArrayVector)other, otherOffset, array, arrayOffset, length);
            return;
        }
        assert (offset >= 0);
        assert (offset + length <= this.length());
        double[] thisArray = this.getArray();
        offset += this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * thisArray[i + offset] * other.unsafeGet(i + otherOffset);
        }
    }

    @Override
    public void addProductToArray(double factor, int offset, AArrayVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        assert (offset >= 0);
        assert (offset + length <= this.length());
        double[] otherArray = other.getArray();
        otherOffset += other.getArrayOffset();
        double[] thisArray = this.getArray();
        offset += this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * thisArray[i + offset] * otherArray[i + otherOffset];
        }
    }

    public void add(AArrayVector src, int srcOffset) {
        int length = this.length();
        double[] vdata = src.getArray();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        int voffset = src.getArrayOffset() + srcOffset;
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i];
        }
    }

    @Override
    public void addAt(int i, double v) {
        assert (i >= 0 && i < this.length());
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        int n = i + offset;
        data[n] = data[n] + v;
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return DoubleArrays.dotProduct(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public double dotProduct(AVector v) {
        int length = this.length();
        if (length != v.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        if (v instanceof AArrayVector) {
            AArrayVector vv = (AArrayVector)v;
            return DoubleArrays.dotProduct(this.getArray(), this.getArrayOffset(), vv.getArray(), vv.getArrayOffset(), length);
        }
        return v.dotProduct(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void abs() {
        DoubleArrays.abs(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void log() {
        DoubleArrays.log(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void exp() {
        DoubleArrays.exp(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void square() {
        DoubleArrays.square(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void sqrt() {
        DoubleArrays.sqrt(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void signum() {
        DoubleArrays.signum(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void multiply(AVector v) {
        v.multiplyTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void multiply(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            data[i + offset] = cdata[i + coffset] * data[i + offset];
        }
    }

    @Override
    public void multiplyTo(double[] data, int offset) {
        DoubleArrays.arraymultiply(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public void divide(AVector v) {
        v.divideTo(this.getArray(), this.getArrayOffset());
    }

    @Override
    public void divide(double[] data, int offset) {
        int len = this.length();
        double[] cdata = this.getArray();
        int coffset = this.getArrayOffset();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, cdata[i + coffset] / data[i + offset]);
        }
    }

    @Override
    public void divideTo(double[] data, int offset) {
        DoubleArrays.arraydivide(this.getArray(), this.getArrayOffset(), data, offset, this.length());
    }

    @Override
    public void copyTo(int start, AVector dest, int destOffset, int length) {
        if (dest instanceof AArrayVector) {
            this.copyTo(start, (AArrayVector)dest, destOffset, length);
            return;
        }
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            dest.unsafeSet(destOffset + i, src[off + start + i]);
        }
    }

    public void copyTo(int offset, AArrayVector dest, int destOffset, int length) {
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        double[] dst = dest.getArray();
        System.arraycopy(src, off + offset, dst, dest.getArrayOffset() + destOffset, length);
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        double[] src = this.getArray();
        int off = this.getArrayOffset();
        System.arraycopy(src, off + offset, dest, destOffset, length);
    }

    public void addMultiple(AArrayVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public double magnitudeSquared() {
        int length = this.length();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            double v = data[offset + i];
            result += v * v;
        }
        return result;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    @Override
    public void fill(double value) {
        int offset = this.getArrayOffset();
        Arrays.fill(this.getArray(), offset, offset + this.length(), value);
    }

    @Override
    public void pow(double exponent) {
        int len = this.length();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        DoubleArrays.pow(data, offset, len, exponent);
    }

    @Override
    public void reciprocal() {
        DoubleArrays.reciprocal(this.getArray(), this.getArrayOffset(), this.length());
    }

    @Override
    public void clamp(double min, double max) {
        DoubleArrays.clamp(this.getArray(), this.getArrayOffset(), this.length(), min, max);
    }

    @Override
    public void multiply(double factor) {
        DoubleArrays.multiply(this.getArray(), this.getArrayOffset(), this.length(), factor);
    }

    @Override
    public AVector join(AVector v) {
        if (v instanceof AArrayVector) {
            return this.join((AArrayVector)v);
        }
        if (v instanceof JoinedArrayVector) {
            return this.join((JoinedArrayVector)v);
        }
        return super.join(v);
    }

    public AVector join(AArrayVector v) {
        if (v.getArray() == this.getArray() && this.getArrayOffset() + this.length() == v.getArrayOffset()) {
            return Vectorz.wrap(this.getArray(), this.getArrayOffset(), this.length() + v.length());
        }
        return JoinedArrayVector.joinVectors(this, v);
    }

    public JoinedArrayVector join(JoinedArrayVector v) {
        return JoinedArrayVector.wrap(this).join(v);
    }

    @Override
    public void validate() {
        int length = this.length();
        double[] data = this.getArray();
        int offset = this.getArrayOffset();
        if (offset < 0 || offset + length > data.length) {
            throw new VectorzException("ArrayVector out of bounds");
        }
        super.validate();
    }
}

