/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.impl.IStridedArray;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.AArrayMatrix;
import mikera.matrixx.impl.StridedMatrix;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AStridedMatrix
extends AArrayMatrix
implements IStridedArray {
    protected AStridedMatrix(double[] data, int rows, int cols) {
        super(data, rows, cols);
    }

    @Override
    public abstract int getArrayOffset();

    public abstract int rowStride();

    public abstract int columnStride();

    @Override
    public AStridedMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        if (rowStart < 0 || rowStart >= rows || colStart < 0 || colStart >= cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart, colStart));
        }
        if (rowStart + rows > this.rows || colStart + cols > this.cols) {
            throw new IndexOutOfBoundsException(ErrorMessages.position(rowStart + rows, colStart + cols));
        }
        if (rows < 1 || cols < 1) {
            throw new IllegalArgumentException(ErrorMessages.illegalSize(rows, cols));
        }
        return StridedMatrix.wrap(this.data, rows, cols, this.getArrayOffset() + rowStart * this.rowStride() + colStart * this.columnStride(), this.rowStride(), this.columnStride());
    }

    @Override
    public AStridedVector getRow(int i) {
        return Vectorz.wrapStrided(this.data, this.getArrayOffset() + i * this.rowStride(), this.cols, this.columnStride());
    }

    @Override
    public AStridedVector getColumn(int i) {
        return Vectorz.wrapStrided(this.data, this.getArrayOffset() + i * this.columnStride(), this.rows, this.rowStride());
    }

    @Override
    public int[] getStrides() {
        return new int[]{this.rowStride(), this.columnStride()};
    }

    @Override
    public int getStride(int dimension) {
        switch (dimension) {
            case 0: {
                return this.rowStride();
            }
            case 1: {
                return this.columnStride();
            }
        }
        throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
    }

    @Override
    public AMatrix getTransposeView() {
        return Matrixx.wrapStrided(this.getArray(), this.columnCount(), this.rowCount(), this.getArrayOffset(), this.columnStride(), this.rowStride());
    }

    @Override
    public boolean isPackedArray() {
        return this.getArrayOffset() == 0 && this.columnStride() == 1 && this.rowStride() == this.columnCount() && (long)this.getArray().length == this.elementCount();
    }

    @Override
    public double[] asDoubleArray() {
        if (this.isPackedArray()) {
            return this.getArray();
        }
        return null;
    }
}

