/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class DiagonalMatrix
extends ADiagonalMatrix {
    final double[] data;

    public DiagonalMatrix(int dimensions) {
        super(dimensions);
        this.data = new double[dimensions];
    }

    private DiagonalMatrix(double ... values) {
        super(values.length);
        this.data = values;
    }

    public static DiagonalMatrix createDimensions(int dims) {
        return new DiagonalMatrix(dims);
    }

    public static DiagonalMatrix create(double ... values) {
        int dimensions = values.length;
        double[] data = new double[dimensions];
        System.arraycopy(values, 0, data, 0, dimensions);
        return new DiagonalMatrix(data);
    }

    public static DiagonalMatrix create(AVector v) {
        return DiagonalMatrix.wrap(v.toDoubleArray());
    }

    public static DiagonalMatrix wrap(double[] data) {
        return new DiagonalMatrix(data);
    }

    @Override
    public double trace() {
        double result = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            result += this.data[i];
        }
        return result;
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data, 0, this.dimensions);
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data, 0, this.dimensions);
    }

    @Override
    public double get(int row, int column) {
        if (row != column) {
            if (row < 0 || row >= this.dimensions) {
                throw new IndexOutOfBoundsException(ErrorMessages.position(row, column));
            }
            return 0.0;
        }
        return this.data[row];
    }

    @Override
    public double unsafeGet(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.data[row];
    }

    @Override
    public void set(int row, int column, double value) {
        if (row != column) {
            if (value != 0.0) {
                throw new UnsupportedOperationException(ErrorMessages.notFullyMutable(this, row, column));
            }
        } else {
            this.data[row] = value;
        }
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        this.data[row] = value;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return this.dimensions <= 1;
    }

    @Override
    public void multiply(double factor) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return this.data[i] * v.unsafeGet(i);
    }

    @Override
    public double calculateElement(int i, Vector v) {
        return this.data[i] * v.unsafeGet(i);
    }

    @Override
    public void transform(Vector source, Vector dest) {
        int rc;
        int cc = rc = this.rowCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int i = 0; i < rc; ++i) {
            dest.data[i] = source.data[i] * this.data[i];
        }
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v instanceof AArrayVector) {
            this.transformInPlace((AArrayVector)v);
            return;
        }
        if (v.length() != this.dimensions) {
            throw new IllegalArgumentException("Wrong length vector: " + v.length());
        }
        for (int i = 0; i < this.dimensions; ++i) {
            v.unsafeSet(i, v.unsafeGet(i) * this.data[i]);
        }
    }

    @Override
    public void transformInPlace(AArrayVector v) {
        double[] dest = v.getArray();
        int offset = v.getArrayOffset();
        DoubleArrays.arraymultiply(this.data, 0, dest, offset, this.dimensions);
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.data[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoolean() {
        return DoubleArrays.isBoolean(this.data, 0, this.dimensions);
    }

    @Override
    public DiagonalMatrix clone() {
        DiagonalMatrix m = new DiagonalMatrix(this.data);
        return m;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.data[i];
        }
        return det;
    }

    @Override
    public DiagonalMatrix inverse() {
        double[] newData = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            newData[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(newData);
    }

    @Override
    public double getDiagonalValue(int i) {
        return this.data[i];
    }

    @Override
    public double unsafeGetDiagonalValue(int i) {
        return this.data[i];
    }

    @Override
    public Vector getLeadingDiagonal() {
        return Vector.wrap(this.data);
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.innerProduct((ADiagonalMatrix)a);
        }
        return super.innerProduct(a);
    }

    @Override
    public DiagonalMatrix innerProduct(ADiagonalMatrix a) {
        if (this.dimensions != a.dimensions) {
            throw new IllegalArgumentException("Matrix dimensions not compatible!");
        }
        DiagonalMatrix result = DiagonalMatrix.create(this.data);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            result.data[n] = result.data[n] * a.unsafeGetDiagonalValue(i);
        }
        return result;
    }

    @Override
    public DiagonalMatrix exactClone() {
        return DiagonalMatrix.create(this.data);
    }

    @Override
    public void validate() {
        if (this.dimensions != this.data.length) {
            throw new VectorzException("dimension mismatch: " + this.dimensions);
        }
        super.validate();
    }
}

