/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.impl.ADelegatedMatrix;
import mikera.vectorz.AVector;

public class TransposedMatrix
extends ADelegatedMatrix {
    private TransposedMatrix(AMatrix source) {
        super(source);
    }

    public static AMatrix wrap(AMatrix m) {
        if (m instanceof TransposedMatrix) {
            return ((TransposedMatrix)m).source;
        }
        return new TransposedMatrix(m);
    }

    @Override
    public int rowCount() {
        return this.source.columnCount();
    }

    @Override
    public int columnCount() {
        return this.source.rowCount();
    }

    @Override
    public double get(int row, int column) {
        return this.source.get(column, row);
    }

    @Override
    public void set(int row, int column, double value) {
        this.source.set(column, row, value);
    }

    @Override
    public AVector getRow(int row) {
        return this.source.getColumn(row);
    }

    @Override
    public AVector slice(int rowNumber) {
        return this.source.getColumn(rowNumber);
    }

    @Override
    public int sliceCount() {
        return this.source.columnCount();
    }

    @Override
    public Matrix toMatrixTranspose() {
        if (this.source instanceof Matrix) {
            return (Matrix)this.source;
        }
        return this.source.toMatrix();
    }

    @Override
    public Matrix toMatrix() {
        return this.source.toMatrixTranspose();
    }

    @Override
    public AVector getColumn(int column) {
        return this.source.getRow(column);
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        this.source.getColumn(row).copyTo(dest, destOffset);
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        this.source.getRow(col).copyTo(dest, destOffset);
    }

    @Override
    public double determinant() {
        return this.source.determinant();
    }

    @Override
    public boolean isSymmetric() {
        return this.source.isSymmetric();
    }

    @Override
    public boolean isUpperTriangular() {
        return this.source.isLowerTriangular();
    }

    @Override
    public boolean isLowerTriangular() {
        return this.source.isUpperTriangular();
    }

    @Override
    public AMatrix getTranspose() {
        return this.source;
    }

    @Override
    public AMatrix getTransposeView() {
        return this.source;
    }

    @Override
    public Matrix transposeInnerProduct(Matrix s) {
        return this.source.innerProduct(s);
    }

    @Override
    public TransposedMatrix exactClone() {
        return new TransposedMatrix(this.source.exactClone());
    }
}

