/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.impl.IStridedArray;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.StridedMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AStridedVector
extends AVector
implements IStridedArray {
    private static final long serialVersionUID = -7239429584755803950L;

    @Override
    public abstract double[] getArray();

    @Override
    public abstract int getArrayOffset();

    public abstract int getStride();

    @Override
    public AStridedVector ensureMutable() {
        return this.clone();
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        double[] array = this.getArray();
        int thisOffset = this.getArrayOffset();
        int stride = this.getStride();
        int length = this.length();
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result += array[i * stride + thisOffset] * data[i + offset];
        }
        return result;
    }

    @Override
    public INDArray broadcast(int ... shape) {
        int dims = shape.length;
        if (dims == 0) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, shape));
        }
        if (dims == 1) {
            if (shape[0] != this.length()) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, shape));
            }
            return this;
        }
        if (dims == 2) {
            int rc = shape[0];
            int cc = shape[1];
            if (cc != this.length()) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, shape));
            }
            return Matrixx.wrapStrided(this.getArray(), rc, cc, this.getArrayOffset(), 0, this.getStride());
        }
        if (shape[dims - 1] != this.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, shape));
        }
        int[] newStrides = new int[dims];
        newStrides[dims - 1] = this.getStride();
        return Arrayz.wrapStrided(this.getArray(), this.getArrayOffset(), shape, newStrides);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        if (target instanceof AMatrix) {
            return this.broadcastLike((AMatrix)target);
        }
        return this.broadcast(target.getShape());
    }

    @Override
    public INDArray broadcastLike(AMatrix target) {
        if (this.length() == target.columnCount()) {
            return StridedMatrix.wrap(this.getArray(), target.rowCount(), this.length(), this.getArrayOffset(), 0, this.getStride());
        }
        throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, target));
    }

    @Override
    public AStridedVector clone() {
        return Vector.create(this);
    }

    public void add(Vector v) {
        int length = this.length();
        if (length != v.length()) {
            throw new IllegalArgumentException("Mismatched vector sizes");
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, v.data[i]);
        }
    }

    @Override
    public double[] asDoubleArray() {
        if (this.isPackedArray()) {
            return this.getArray();
        }
        return null;
    }

    @Override
    public boolean isPackedArray() {
        return this.getStride() == 1 && this.getArrayOffset() == 0 && this.getArray().length == this.length();
    }

    @Override
    public int[] getStrides() {
        return new int[]{this.getStride()};
    }

    @Override
    public int getStride(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getStride();
            }
        }
        throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
    }
}

