/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.VectorzException;

public final class StridedVector
extends AStridedVector {
    private static final long serialVersionUID = 5807998427323932401L;
    private final double[] data;
    private final int length;
    private final int offset;
    private final int stride;

    private StridedVector(double[] data, int offset, int length, int stride) {
        int lastOffset;
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length > 0 && ((lastOffset = offset + (length - 1) * stride) >= data.length || lastOffset < 0)) {
            throw new IndexOutOfBoundsException();
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.stride = stride;
    }

    public static StridedVector wrapStrided(double[] data, int offset, int length, int stride) {
        return new StridedVector(data, offset, length, stride);
    }

    public static StridedVector wrap(double[] data, int offset, int length, int stride) {
        return StridedVector.wrapStrided(data, offset, length, stride);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public double dotProduct(AVector v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Vector size mismatch");
        }
        if (v instanceof AArrayVector) {
            AArrayVector av = (AArrayVector)v;
            return this.dotProduct(av.getArray(), av.getArrayOffset());
        }
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.data[this.offset + i * this.stride] * v.unsafeGet(i);
        }
        return result;
    }

    @Override
    public void set(AVector v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Vector size mismatch");
        }
        for (int i = 0; i < this.length; ++i) {
            this.data[this.offset + i * this.stride] = v.unsafeGet(i);
        }
    }

    @Override
    public void add(AVector v) {
        if (v instanceof AStridedVector) {
            this.add((AStridedVector)v);
            return;
        }
        super.add(v);
    }

    public void add(AStridedVector v) {
        if (this.length != v.length()) {
            throw new IllegalArgumentException("Mismatched vector lengths");
        }
    }

    @Override
    public int getStride() {
        return this.stride;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (length == 1) {
            return ArraySubVector.wrap(this.data, this.offset + start * this.stride, 1);
        }
        if (length > 0) {
            return StridedVector.wrapStrided(this.data, this.offset + start * this.stride, length, this.stride);
        }
        return Vector0.INSTANCE;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int n = this.offset + i * this.stride;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void copyTo(double[] dest, int destOffset) {
        for (int i = 0; i < this.length; ++i) {
            dest[destOffset + i] = this.data[this.offset + i * this.stride];
        }
    }

    @Override
    public StridedVector exactClone() {
        double[] data = (double[])this.data.clone();
        return StridedVector.wrapStrided(data, this.offset, this.length, this.stride);
    }

    @Override
    public void validate() {
        if (this.length > 0) {
            if (this.offset < 0 || this.offset >= this.data.length) {
                throw new VectorzException("offset out of bounds: " + this.offset);
            }
            int lastIndex = this.offset + this.stride * (this.length - 1);
            if (lastIndex < 0 || lastIndex >= this.data.length) {
                throw new VectorzException("lastIndex out of bounds: " + lastIndex);
            }
        }
        super.validate();
    }
}

