/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AVectorMatrix<T extends AVector>
extends AMatrix {
    public abstract void appendRow(AVector var1);

    public abstract T getRow(int var1);

    @Override
    public double get(int row, int column) {
        return ((AVector)this.getRow(row)).get(column);
    }

    @Override
    public double unsafeGet(int row, int column) {
        return ((AVector)this.getRow(row)).unsafeGet(column);
    }

    @Override
    public boolean isFullyMutable() {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (((AVector)this.getRow(i)).isFullyMutable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void set(double value) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            ((AVector)this.getRow(i)).set(value);
        }
    }

    @Override
    public void set(int row, int column, double value) {
        ((AVector)this.getRow(row)).set(column, value);
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        ((AVector)this.getRow(row)).unsafeSet(column, value);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector && dest instanceof Vector) {
            this.transform((Vector)source, (Vector)dest);
            return;
        }
        int rc = this.rowCount();
        if (rc != dest.length()) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int i = 0; i < rc; ++i) {
            dest.unsafeSet(i, ((AVector)this.getRow(i)).dotProduct(source));
        }
    }

    @Override
    public void transform(Vector source, Vector dest) {
        int rc = this.rowCount();
        if (rc != dest.length()) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int i = 0; i < rc; ++i) {
            dest.unsafeSet(i, ((AVector)this.getRow(i)).dotProduct(source));
        }
    }

    @Override
    public double calculateElement(int i, AVector inputVector) {
        T row = this.getRow(i);
        return ((AVector)row).dotProduct(inputVector);
    }

    @Override
    public final void copyRowTo(int row, double[] dest, int destOffset) {
        ((AVector)this.getRow(row)).getElements(dest, destOffset);
    }

    @Override
    public final void getElements(double[] dest, int destOffset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            ((AVector)this.getRow(i)).getElements(dest, destOffset);
            destOffset += cc;
        }
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            ((AVector)this.getRow(i)).applyOp(op);
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isZero() {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            if (((AVector)this.getRow(i)).isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double elementSum() {
        int rc = this.rowCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += ((AVector)this.getRow(i)).elementSum();
        }
        return result;
    }

    @Override
    public double elementSquaredSum() {
        int rc = this.rowCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += ((AVector)this.getRow(i)).elementSquaredSum();
        }
        return result;
    }

    @Override
    public long nonZeroCount() {
        int rc = this.rowCount();
        long result = 0L;
        for (int i = 0; i < rc; ++i) {
            result += ((AVector)this.getRow(i)).nonZeroCount();
        }
        return result;
    }

    @Override
    public AMatrix clone() {
        AMatrix avm = super.clone();
        return avm;
    }
}

