/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AMatrixViewVector
extends AVector {
    protected AMatrix source;
    protected int length;

    protected AMatrixViewVector(AMatrix source, int length) {
        this.source = source;
        this.length = length;
    }

    protected abstract int calcRow(int var1);

    protected abstract int calcCol(int var1);

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        this.source.unsafeSet(this.calcRow(i), this.calcCol(i), value);
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.source.unsafeSet(this.calcRow(i), this.calcCol(i), value);
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        return this.source.unsafeGet(this.calcRow(i), this.calcCol(i));
    }

    @Override
    public double unsafeGet(int i) {
        return this.source.unsafeGet(this.calcRow(i), this.calcCol(i));
    }

    @Override
    public int length() {
        return this.length;
    }
}

