/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.util;

import mikera.arrayz.INDArray;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;

public class ErrorMessages {
    private static String shape(INDArray a) {
        return Index.of(a.getShape()).toString();
    }

    private static String shape(int ... indexes) {
        return Index.of(indexes).toString();
    }

    private static String pos(int ... indexes) {
        return Index.of(indexes).toString();
    }

    public static String mismatch(INDArray a, INDArray b) {
        return "Mismatched sizes: " + ErrorMessages.shape(a) + " vs. " + ErrorMessages.shape(b);
    }

    public static String incompatibleShapes(INDArray a, INDArray b) {
        return "Incompatible shapes: " + ErrorMessages.shape(a) + " vs. " + ErrorMessages.shape(b);
    }

    public static String incompatibleShape(INDArray m) {
        return "Incompatible shape: " + ErrorMessages.shape(m);
    }

    public static String incompatibleBroadcast(INDArray a, int ... shape) {
        return "Can't broadcast " + a.getClass() + " with shape " + ErrorMessages.shape(a) + " to shape: " + ErrorMessages.shape(shape);
    }

    public static String notFullyMutable(AMatrix m, int row, int column) {
        return "Can't mutate " + m.getClass() + " at position: " + ErrorMessages.pos(row, column);
    }

    public static String wrongDestLength(AVector dest) {
        return "Wrong destination vector size: " + ErrorMessages.shape(dest);
    }

    public static String wrongSourceLength(AVector source) {
        return "Wrong source vector size: " + ErrorMessages.shape(source);
    }

    public static String squareMatrixRequired(AMatrix m) {
        return "Square matrix required! This matrix has shape: " + ErrorMessages.shape(m);
    }

    public static String position(int ... indexes) {
        return "Invalid index: " + ErrorMessages.pos(indexes);
    }

    public static String illegalSize(int ... shape) {
        return "Illegal shape" + ErrorMessages.shape(shape);
    }

    public static String immutable(Object a) {
        return a.getClass().toString() + " is immutable!";
    }

    public static String invalidDimension(INDArray a, int dimension) {
        return "" + a.getClass() + " with shape " + ErrorMessages.shape(a) + " does not have dimension: " + dimension;
    }

    public static String invalidIndex(INDArray a, int ... indexes) {
        int[] shape = a.getShape();
        if (shape.length != indexes.length) {
            return "" + indexes.length + "-D access with index " + ErrorMessages.pos(indexes) + " not possible for " + a.getClass() + " with shape " + ErrorMessages.shape(shape);
        }
        return "Access at position " + ErrorMessages.pos(indexes) + " not possible for " + a.getClass() + " with shape " + ErrorMessages.shape(shape);
    }

    public static String invalidRange(AVector v, int start, int length) {
        return "Subrange {start=" + start + ", length=" + length + "} not valid on vector with length " + v.length();
    }

    public static String invalidSlice(INDArray a, int slice) {
        return "" + a.getClass() + " with shape " + ErrorMessages.shape(a) + " does not have slice: " + slice;
    }

    public static String noSlices(INDArray a) {
        return "Cannot access slices of 0-D " + a.getClass();
    }
}

