/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class JoinedVector
extends AVector {
    private static final long serialVersionUID = -5535850407701653222L;
    private final AVector left;
    private final AVector right;
    private final int split;
    private final int length;

    public JoinedVector(AVector left, AVector right) {
        if (left.length() * 2 < right.length() && right instanceof JoinedVector) {
            JoinedVector v = new JoinedVector(left, ((JoinedVector)right).left);
            left = v;
            right = ((JoinedVector)right).right;
        } else if (left.length() > right.length() * 2 && left instanceof JoinedVector) {
            JoinedVector v = new JoinedVector(((JoinedVector)left).right, right);
            left = ((JoinedVector)left).left;
            right = v;
        }
        this.left = left;
        this.right = right;
        this.split = left.length();
        this.length = this.split + right.length();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public void copyTo(AVector dest, int offset) {
        this.left.copyTo(dest, offset);
        this.right.copyTo(dest, offset + this.split);
    }

    @Override
    public void copyTo(double[] data, int offset) {
        this.left.copyTo(data, offset);
        this.right.copyTo(data, offset + this.split);
    }

    @Override
    public void copy(int start, int length, AVector dest, int destOffset) {
        this.subVector(start, length).copyTo(dest, destOffset);
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (length <= this.length);
        if (start >= this.split) {
            return this.right.subVector(start - this.split, length);
        }
        if (start + length <= this.split) {
            return this.left.subVector(start, length);
        }
        if (length == this.length) {
            return this;
        }
        AVector v1 = this.left.subVector(start, this.split - start);
        AVector v2 = this.right.subVector(0, length - (this.split - start));
        return new JoinedVector(v1, v2);
    }

    @Override
    public void add(AVector a) {
        assert (this.length() == a.length());
        this.add(a, 0);
    }

    @Override
    public void add(AVector a, int offset) {
        this.left.add(a, offset);
        this.right.add(a, offset + this.split);
    }

    @Override
    public double get(int i) {
        if (i < this.split) {
            return this.left.get(i);
        }
        return this.right.get(i - this.split);
    }

    @Override
    public void set(AVector src) {
        this.set(src, 0);
    }

    @Override
    public void set(AVector src, int offset) {
        this.left.set(src, offset);
        this.right.set(src, offset + this.split);
    }

    @Override
    public void set(int i, double value) {
        if (i < this.split) {
            this.left.set(i, value);
        } else {
            this.right.set(i - this.split, value);
        }
    }

    @Override
    public void fill(double value) {
        this.left.fill(value);
        this.right.fill(value);
    }

    @Override
    public void multiply(double value) {
        this.left.multiply(value);
        this.right.multiply(value);
    }
}

