/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import mikera.matrixx.IMatrix;
import mikera.matrixx.MatrixMN;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.MatrixSubVector;
import mikera.matrixx.impl.TransposedMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.transformz.AAffineTransform;
import mikera.transformz.ATranslation;
import mikera.transformz.AffineMN;
import mikera.transformz.Transformz;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.ZeroLengthVector;
import mikera.vectorz.util.VectorzException;

public abstract class AMatrix
extends AAffineTransform
implements IMatrix {
    @Override
    public abstract int rowCount();

    @Override
    public abstract int columnCount();

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public AAffineTransform toAffineTransform() {
        return new AffineMN((AMatrix)new VectorMatrixMN(this), Transformz.identityTransform(this.outputDimensions()));
    }

    @Override
    public AMatrix getMatrixComponent() {
        return this;
    }

    @Override
    public ATranslation getTranslationComponent() {
        return Transformz.identityTransform(this.rowCount());
    }

    public boolean isSquare() {
        return this.rowCount() == this.columnCount();
    }

    @Override
    public int inputDimensions() {
        return this.columnCount();
    }

    @Override
    public int outputDimensions() {
        return this.rowCount();
    }

    @Override
    public void transform(AVector source, AVector dest) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.get(row, column) * source.get(column);
            }
            dest.set(row, total);
        }
    }

    @Override
    public void transformInPlace(AVector v) {
        int cc;
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.get(row, column) * v.get(column);
            }
            temp[row] = total;
        }
        v.setValues(temp);
    }

    public AVector getRow(int row) {
        return new MatrixRow(row);
    }

    public AVector getColumn(int column) {
        return new MatrixColumn(column);
    }

    public AVector cloneRow(int row) {
        int cc = this.columnCount();
        AVector v = Vectorz.newVector(cc);
        for (int i = 0; i < cc; ++i) {
            v.set(i, this.get(row, i));
        }
        return v;
    }

    public void set(AMatrix a) {
        int rc = this.rowCount();
        if (a.rowCount() != rc) {
            throw new IllegalArgumentException("Source matrix has wrog number of rows: " + a.rowCount());
        }
        int cc = this.columnCount();
        if (a.columnCount() != cc) {
            throw new IllegalArgumentException("Source matrix has wrong number of columns: " + a.columnCount());
        }
        for (int row = 0; row < rc; ++row) {
            for (int column = 0; column < cc; ++column) {
                this.set(row, column, a.get(row, column));
            }
        }
    }

    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public AMatrix clone() {
        return Matrixx.deepCopy(this);
    }

    public double determinant() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Cannot take determinant of non-squae matrix!");
        }
        int rc = this.rowCount();
        int[] inds = new int[rc];
        for (int i = 0; i < rc; ++i) {
            inds[i] = i;
        }
        return this.calcDeterminant(inds, 0);
    }

    private static void swap(int[] inds, int a, int b) {
        int temp = inds[a];
        inds[a] = inds[b];
        inds[b] = temp;
    }

    private double calcDeterminant(int[] inds, int offset) {
        int rc = this.rowCount();
        if (offset == rc - 1) {
            return this.get(offset, inds[offset]);
        }
        double det = this.get(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
        for (int i = 1; i < rc - offset; ++i) {
            AMatrix.swap(inds, offset, offset + i);
            det -= this.get(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
            AMatrix.swap(inds, offset, offset + i);
        }
        return det;
    }

    public AMatrix toMutableMatrix() {
        return Matrixx.create(this);
    }

    public void transposeInPlace() {
        if (!this.isSquare()) {
            throw new Error("Only square matrixes can be transposed in place!");
        }
        int dims = this.rowCount();
        for (int i = 0; i < dims; ++i) {
            for (int j = i + 1; j < dims; ++j) {
                double temp = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, temp);
            }
        }
    }

    public AMatrix getTranspose() {
        return TransposedMatrix.wrap(this);
    }

    public void add(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + m.get(i, j));
            }
        }
    }

    public void addMultiple(AMatrix m, double factor) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + m.get(i, j) * factor);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AMatrix)) {
            return false;
        }
        return this.equals((AMatrix)o);
    }

    public boolean equals(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.rowCount()) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != a.columnCount()) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.get(i, j) == a.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean epsilonEquals(AMatrix a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != a.rowCount() || cc != a.columnCount()) {
            throw new VectorzException("Mismatched matrix sizes!");
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (Tools.epsilonEquals(this.get(i, j), a.get(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(AAffineTransform a) {
        return a.getTranslationComponent().isIdentity() && this.equals(a.getMatrixComponent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int rc = this.rowCount();
        sb.append("[");
        for (int i = 0; i < rc; ++i) {
            sb.append(this.getRow(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                hashCode = 31 * hashCode + Tools.hashCode(this.get(i, j));
            }
        }
        return hashCode;
    }

    public AVector asVector() {
        int rc = this.rowCount();
        if (rc == 0) {
            return ZeroLengthVector.INSTANCE;
        }
        AVector v = this.getRow(0);
        for (int i = 1; i < rc; ++i) {
            v = Vectorz.join(v, this.getRow(i));
        }
        return v;
    }

    @Override
    public AMatrix inverse() {
        MatrixMN result = Matrixx.createInverse(this);
        return result;
    }

    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getRow(i);
        AVector b = this.getRow(j);
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = a.get(k);
            a.set(k, b.get(k));
            b.set(k, t);
        }
    }

    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getColumn(i);
        AVector b = this.getColumn(j);
        int rc = this.rowCount();
        for (int k = 0; k < rc; ++k) {
            double t = a.get(k);
            a.set(k, b.get(k));
            b.set(k, t);
        }
    }

    public AVector toVector() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        AVector v = Vectorz.newVector(rc * cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                v.set(i * cc + j, this.get(i, j));
            }
        }
        return v;
    }

    private class MatrixColumn
    extends MatrixSubVector {
        private final int column;

        private MatrixColumn(int column) {
            this.column = column;
        }

        @Override
        public int length() {
            return AMatrix.this.rowCount();
        }

        @Override
        public double get(int i) {
            return AMatrix.this.get(i, this.column);
        }

        @Override
        public void set(int i, double value) {
            AMatrix.this.set(i, this.column, value);
        }
    }

    private class MatrixRow
    extends MatrixSubVector {
        private final int row;

        private MatrixRow(int row) {
            this.row = row;
        }

        @Override
        public int length() {
            return AMatrix.this.columnCount();
        }

        @Override
        public double get(int i) {
            return AMatrix.this.get(this.row, i);
        }

        @Override
        public void set(int i, double value) {
            AMatrix.this.set(this.row, i, value);
        }
    }
}

