/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.transformz.ATranslation;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class IdentityTranslation
extends ATranslation {
    private final int dimensions;

    private IdentityTranslation(int dims) {
        this.dimensions = dims;
    }

    @Override
    public AMatrix getMatrixComponent() {
        return Matrixx.createIdentityMatrix(this.dimensions);
    }

    @Override
    public ATranslation getTranslationComponent() {
        return this;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source);
    }

    @Override
    public void transformInPlace(AVector v) {
    }

    @Override
    public int inputDimensions() {
        return this.dimensions;
    }

    @Override
    public int outputDimensions() {
        return this.dimensions;
    }

    public static IdentityTranslation getInstance(int dimensions) {
        return new IdentityTranslation(dimensions);
    }

    @Override
    public AVector getTranslationVector() {
        return Vectorz.immutableZeroVector(this.dimensions);
    }
}

