/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz.impl;

import mikera.transformz.ATranslation;
import mikera.transformz.Transformz;
import mikera.transformz.impl.AConstantTransform;
import mikera.vectorz.AVector;

public final class ConstantTransform
extends AConstantTransform {
    private final int outputDimensions;
    private double[] constant;

    public ConstantTransform(int inputDimensions, AVector value) {
        super(inputDimensions);
        this.outputDimensions = value.length();
        this.constant = new double[this.outputDimensions];
        value.copyTo(this.constant, 0);
    }

    @Override
    public int outputDimensions() {
        return this.outputDimensions;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        assert (source.length() == this.inputDimensions());
        dest.setValues(this.constant);
    }

    @Override
    public ATranslation getTranslationComponent() {
        return Transformz.createTranslation(this.constant);
    }
}

