/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class DiagonalMatrix
extends AMatrix {
    final int dimensions;
    final double[] data;

    public DiagonalMatrix(int dimensions) {
        this.dimensions = dimensions;
        this.data = new double[dimensions];
    }

    public DiagonalMatrix(double ... values) {
        this.dimensions = values.length;
        this.data = new double[this.dimensions];
        System.arraycopy(values, 0, this.data, 0, this.dimensions);
    }

    @Override
    public int rowCount() {
        return this.dimensions;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public int columnCount() {
        return this.dimensions;
    }

    @Override
    public double get(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.data[row];
    }

    @Override
    public void set(int row, int column, double value) {
        if (row != column) {
            if (value != 0.0) {
                throw new UnsupportedOperationException("Diagonal matrix cannot be set to non-zero value at position (" + row + "," + column + ")!");
            }
        } else {
            this.data[row] = value;
        }
    }

    @Override
    public double calculateComponent(int i, AVector v) {
        return v.get(i) * this.data[i];
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v.length() != this.dimensions) {
            throw new IllegalArgumentException("Wrong length vector: " + v.length());
        }
        for (int i = 0; i < this.dimensions; ++i) {
            v.set(i, v.get(i) * this.data[i]);
        }
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.data[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public DiagonalMatrix clone() {
        DiagonalMatrix m = new DiagonalMatrix(this.data);
        return m;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.data[i];
        }
        return det;
    }

    @Override
    public AVector getLeadingDiagonal() {
        return Vectorz.create(this.data);
    }

    @Override
    public void transposeInPlace() {
    }
}

