/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public class IdentityMatrix
extends ADiagonalMatrix {
    private static final int INSTANCE_COUNT = 6;
    private static final IdentityMatrix[] INSTANCES = new IdentityMatrix[6];

    private IdentityMatrix(int dimensions) {
        super(dimensions);
    }

    public static IdentityMatrix create(int i) {
        if (i < 6) {
            return INSTANCES[i];
        }
        return new IdentityMatrix(i);
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return v.get(i);
    }

    @Override
    public double get(int row, int column) {
        assert (row >= 0);
        assert (column >= 0);
        assert (row < this.dimensions);
        assert (column < this.dimensions);
        return row == column ? 1.0 : 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("Identity matrix is immutable!");
    }

    @Override
    public void transform(AVector source, AVector dest) {
        dest.set(source);
    }

    @Override
    public AVector transform(AVector source) {
        return source.clone();
    }

    @Override
    public AVector getLeadingDiagonal() {
        AVector v = Vectorz.newVector(this.dimensions);
        v.fill(1.0);
        return v;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public AMatrix inverse() {
        return this;
    }

    @Override
    public double determinant() {
        return 1.0;
    }

    @Override
    public AMatrix compose(AMatrix a) {
        assert (a.rowCount() == this.dimensions);
        return a.clone();
    }

    @Override
    public AMatrix getTranspose() {
        return this;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            IdentityMatrix.INSTANCES[i] = new IdentityMatrix(i);
        }
    }
}

